@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin

import com.pulumi.aws.backup.PlanArgs.builder
import com.pulumi.aws.backup.kotlin.inputs.PlanAdvancedBackupSettingArgs
import com.pulumi.aws.backup.kotlin.inputs.PlanAdvancedBackupSettingArgsBuilder
import com.pulumi.aws.backup.kotlin.inputs.PlanRuleArgs
import com.pulumi.aws.backup.kotlin.inputs.PlanRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS Backup plan resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.backup.Plan;
 * import com.pulumi.aws.backup.PlanArgs;
 * import com.pulumi.aws.backup.inputs.PlanRuleArgs;
 * import com.pulumi.aws.backup.inputs.PlanRuleLifecycleArgs;
 * import com.pulumi.aws.backup.inputs.PlanAdvancedBackupSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Plan("example", PlanArgs.builder()
 *             .rules(PlanRuleArgs.builder()
 *                 .ruleName("my_example_backup_rule")
 *                 .targetVaultName(aws_backup_vault.test().name())
 *                 .schedule("cron(0 12 * * ? *)")
 *                 .lifecycle(PlanRuleLifecycleArgs.builder()
 *                     .deleteAfter(14)
 *                     .build())
 *                 .build())
 *             .advancedBackupSettings(PlanAdvancedBackupSettingArgs.builder()
 *                 .backupOptions(Map.of("WindowsVSS", "enabled"))
 *                 .resourceType("EC2")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Backup Plan using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:backup/plan:Plan test <id>
 * ```
 * @property advancedBackupSettings An object that specifies backup options for each resource type.
 * @property name The display name of a backup plan.
 * @property rules A rule object that specifies a scheduled task that is used to back up a selection of resources.
 * @property tags Metadata that you can assign to help organize the plans you create. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class PlanArgs(
    public val advancedBackupSettings: Output<List<PlanAdvancedBackupSettingArgs>>? = null,
    public val name: Output<String>? = null,
    public val rules: Output<List<PlanRuleArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.backup.PlanArgs> {
    override fun toJava(): com.pulumi.aws.backup.PlanArgs = com.pulumi.aws.backup.PlanArgs.builder()
        .advancedBackupSettings(
            advancedBackupSettings?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .name(name?.applyValue({ args0 -> args0 }))
        .rules(rules?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [PlanArgs].
 */
@PulumiTagMarker
public class PlanArgsBuilder internal constructor() {
    private var advancedBackupSettings: Output<List<PlanAdvancedBackupSettingArgs>>? = null

    private var name: Output<String>? = null

    private var rules: Output<List<PlanRuleArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value An object that specifies backup options for each resource type.
     */
    @JvmName("ssexjcewnvnexfha")
    public suspend fun advancedBackupSettings(`value`: Output<List<PlanAdvancedBackupSettingArgs>>) {
        this.advancedBackupSettings = value
    }

    @JvmName("otgfegxmvneokomj")
    public suspend fun advancedBackupSettings(vararg values: Output<PlanAdvancedBackupSettingArgs>) {
        this.advancedBackupSettings = Output.all(values.asList())
    }

    /**
     * @param values An object that specifies backup options for each resource type.
     */
    @JvmName("bvyuplghfdrddrmp")
    public suspend fun advancedBackupSettings(values: List<Output<PlanAdvancedBackupSettingArgs>>) {
        this.advancedBackupSettings = Output.all(values)
    }

    /**
     * @param value The display name of a backup plan.
     */
    @JvmName("hkagksyhsvcmogdn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A rule object that specifies a scheduled task that is used to back up a selection of resources.
     */
    @JvmName("qxnfvoyojmqlhduf")
    public suspend fun rules(`value`: Output<List<PlanRuleArgs>>) {
        this.rules = value
    }

    @JvmName("dvwxjmjchuiucdvr")
    public suspend fun rules(vararg values: Output<PlanRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values A rule object that specifies a scheduled task that is used to back up a selection of resources.
     */
    @JvmName("vcdhgoxyqdtumuai")
    public suspend fun rules(values: List<Output<PlanRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value Metadata that you can assign to help organize the plans you create. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("etujevqfdhvxecbl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value An object that specifies backup options for each resource type.
     */
    @JvmName("nvxaurclxqkqluwd")
    public suspend fun advancedBackupSettings(`value`: List<PlanAdvancedBackupSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.advancedBackupSettings = mapped
    }

    /**
     * @param argument An object that specifies backup options for each resource type.
     */
    @JvmName("tptncxctibmbvdrx")
    public suspend
    fun advancedBackupSettings(argument: List<suspend PlanAdvancedBackupSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PlanAdvancedBackupSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.advancedBackupSettings = mapped
    }

    /**
     * @param argument An object that specifies backup options for each resource type.
     */
    @JvmName("gfdfwxxkigngpmwj")
    public suspend fun advancedBackupSettings(
        vararg
        argument: suspend PlanAdvancedBackupSettingArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PlanAdvancedBackupSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.advancedBackupSettings = mapped
    }

    /**
     * @param argument An object that specifies backup options for each resource type.
     */
    @JvmName("kapnrcdxofopbejs")
    public suspend
    fun advancedBackupSettings(argument: suspend PlanAdvancedBackupSettingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PlanAdvancedBackupSettingArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.advancedBackupSettings = mapped
    }

    /**
     * @param values An object that specifies backup options for each resource type.
     */
    @JvmName("fvrigidawwovckxl")
    public suspend fun advancedBackupSettings(vararg values: PlanAdvancedBackupSettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.advancedBackupSettings = mapped
    }

    /**
     * @param value The display name of a backup plan.
     */
    @JvmName("nnkywmtyopjqpudy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A rule object that specifies a scheduled task that is used to back up a selection of resources.
     */
    @JvmName("usgbokpjjcloexpa")
    public suspend fun rules(`value`: List<PlanRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument A rule object that specifies a scheduled task that is used to back up a selection of resources.
     */
    @JvmName("shlybxbpqytdeddv")
    public suspend fun rules(argument: List<suspend PlanRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { PlanRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument A rule object that specifies a scheduled task that is used to back up a selection of resources.
     */
    @JvmName("pqnbjyvdmgtfexih")
    public suspend fun rules(vararg argument: suspend PlanRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { PlanRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument A rule object that specifies a scheduled task that is used to back up a selection of resources.
     */
    @JvmName("erxcatuxtsqfbxhi")
    public suspend fun rules(argument: suspend PlanRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PlanRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values A rule object that specifies a scheduled task that is used to back up a selection of resources.
     */
    @JvmName("mufemleauqaxrhpc")
    public suspend fun rules(vararg values: PlanRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param value Metadata that you can assign to help organize the plans you create. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nutdpnmmtptekugu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Metadata that you can assign to help organize the plans you create. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kjjmajeosjpnekyd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PlanArgs = PlanArgs(
        advancedBackupSettings = advancedBackupSettings,
        name = name,
        rules = rules,
        tags = tags,
    )
}
