@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin

import com.pulumi.aws.backup.kotlin.outputs.ReportPlanReportDeliveryChannel
import com.pulumi.aws.backup.kotlin.outputs.ReportPlanReportSetting
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.backup.kotlin.outputs.ReportPlanReportDeliveryChannel.Companion.toKotlin as reportPlanReportDeliveryChannelToKotlin
import com.pulumi.aws.backup.kotlin.outputs.ReportPlanReportSetting.Companion.toKotlin as reportPlanReportSettingToKotlin

/**
 * Builder for [ReportPlan].
 */
@PulumiTagMarker
public class ReportPlanResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReportPlanArgs = ReportPlanArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReportPlanArgsBuilder.() -> Unit) {
        val builder = ReportPlanArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ReportPlan {
        val builtJavaResource = com.pulumi.aws.backup.ReportPlan(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ReportPlan(builtJavaResource)
    }
}

/**
 * Provides an AWS Backup Report Plan resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.backup.ReportPlan;
 * import com.pulumi.aws.backup.ReportPlanArgs;
 * import com.pulumi.aws.backup.inputs.ReportPlanReportDeliveryChannelArgs;
 * import com.pulumi.aws.backup.inputs.ReportPlanReportSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ReportPlan("example", ReportPlanArgs.builder()
 *             .description("example description")
 *             .reportDeliveryChannel(ReportPlanReportDeliveryChannelArgs.builder()
 *                 .formats(
 *                     "CSV",
 *                     "JSON")
 *                 .s3BucketName("example-bucket-name")
 *                 .build())
 *             .reportSetting(ReportPlanReportSettingArgs.builder()
 *                 .reportTemplate("RESTORE_JOB_REPORT")
 *                 .build())
 *             .tags(Map.of("Name", "Example Report Plan"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Backup Report Plan using the `id` which corresponds to the name of the Backup Report Plan. For example:
 * ```sh
 *  $ pulumi import aws:backup/reportPlan:ReportPlan test <id>
 * ```
 *
 */
public class ReportPlan internal constructor(
    override val javaResource: com.pulumi.aws.backup.ReportPlan,
) : KotlinCustomResource(javaResource, ReportPlanMapper) {
    /**
     * The ARN of the backup report plan.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The date and time that a report plan is created, in Unix format and Coordinated Universal Time (UTC).
     */
    public val creationTime: Output<String>
        get() = javaResource.creationTime().applyValue({ args0 -> args0 })

    /**
     * The deployment status of a report plan. The statuses are: `CREATE_IN_PROGRESS` | `UPDATE_IN_PROGRESS` | `DELETE_IN_PROGRESS` | `COMPLETED`.
     */
    public val deploymentStatus: Output<String>
        get() = javaResource.deploymentStatus().applyValue({ args0 -> args0 })

    /**
     * The description of the report plan with a maximum of 1,024 characters
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The unique name of the report plan. The name must be between 1 and 256 characters, starting with a letter, and consisting of letters, numbers, and underscores.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * An object that contains information about where and how to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports. Detailed below.
     */
    public val reportDeliveryChannel: Output<ReportPlanReportDeliveryChannel>
        get() = javaResource.reportDeliveryChannel().applyValue({ args0 ->
            args0.let({ args0 ->
                reportPlanReportDeliveryChannelToKotlin(args0)
            })
        })

    /**
     * An object that identifies the report template for the report. Reports are built using a report template. Detailed below.
     */
    public val reportSetting: Output<ReportPlanReportSetting>
        get() = javaResource.reportSetting().applyValue({ args0 ->
            args0.let({ args0 ->
                reportPlanReportSettingToKotlin(args0)
            })
        })

    /**
     * Metadata that you can assign to help organize the report plans you create. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ReportPlanMapper : ResourceMapper<ReportPlan> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.backup.ReportPlan::class == javaResource::class

    override fun map(javaResource: Resource): ReportPlan = ReportPlan(
        javaResource as
            com.pulumi.aws.backup.ReportPlan,
    )
}

/**
 * @see [ReportPlan].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReportPlan].
 */
public suspend fun reportPlan(name: String, block: suspend ReportPlanResourceBuilder.() -> Unit):
    ReportPlan {
    val builder = ReportPlanResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReportPlan].
 * @param name The _unique_ name of the resulting resource.
 */
public fun reportPlan(name: String): ReportPlan {
    val builder = ReportPlanResourceBuilder()
    builder.name(name)
    return builder.build()
}
