@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin

import com.pulumi.aws.backup.ReportPlanArgs.builder
import com.pulumi.aws.backup.kotlin.inputs.ReportPlanReportDeliveryChannelArgs
import com.pulumi.aws.backup.kotlin.inputs.ReportPlanReportDeliveryChannelArgsBuilder
import com.pulumi.aws.backup.kotlin.inputs.ReportPlanReportSettingArgs
import com.pulumi.aws.backup.kotlin.inputs.ReportPlanReportSettingArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS Backup Report Plan resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.backup.ReportPlan;
 * import com.pulumi.aws.backup.ReportPlanArgs;
 * import com.pulumi.aws.backup.inputs.ReportPlanReportDeliveryChannelArgs;
 * import com.pulumi.aws.backup.inputs.ReportPlanReportSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ReportPlan("example", ReportPlanArgs.builder()
 *             .description("example description")
 *             .reportDeliveryChannel(ReportPlanReportDeliveryChannelArgs.builder()
 *                 .formats(
 *                     "CSV",
 *                     "JSON")
 *                 .s3BucketName("example-bucket-name")
 *                 .build())
 *             .reportSetting(ReportPlanReportSettingArgs.builder()
 *                 .reportTemplate("RESTORE_JOB_REPORT")
 *                 .build())
 *             .tags(Map.of("Name", "Example Report Plan"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Backup Report Plan using the `id` which corresponds to the name of the Backup Report Plan. For example:
 * ```sh
 *  $ pulumi import aws:backup/reportPlan:ReportPlan test <id>
 * ```
 * @property description The description of the report plan with a maximum of 1,024 characters
 * @property name The unique name of the report plan. The name must be between 1 and 256 characters, starting with a letter, and consisting of letters, numbers, and underscores.
 * @property reportDeliveryChannel An object that contains information about where and how to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports. Detailed below.
 * @property reportSetting An object that identifies the report template for the report. Reports are built using a report template. Detailed below.
 * @property tags Metadata that you can assign to help organize the report plans you create. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ReportPlanArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val reportDeliveryChannel: Output<ReportPlanReportDeliveryChannelArgs>? = null,
    public val reportSetting: Output<ReportPlanReportSettingArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.backup.ReportPlanArgs> {
    override fun toJava(): com.pulumi.aws.backup.ReportPlanArgs =
        com.pulumi.aws.backup.ReportPlanArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .reportDeliveryChannel(
                reportDeliveryChannel?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .reportSetting(reportSetting?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ReportPlanArgs].
 */
@PulumiTagMarker
public class ReportPlanArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var reportDeliveryChannel: Output<ReportPlanReportDeliveryChannelArgs>? = null

    private var reportSetting: Output<ReportPlanReportSettingArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The description of the report plan with a maximum of 1,024 characters
     */
    @JvmName("isgtfttxaysmgjrv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The unique name of the report plan. The name must be between 1 and 256 characters, starting with a letter, and consisting of letters, numbers, and underscores.
     */
    @JvmName("wgaulnjrkrvbnquv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value An object that contains information about where and how to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports. Detailed below.
     */
    @JvmName("gouvkkmurasqpmix")
    public suspend fun reportDeliveryChannel(`value`: Output<ReportPlanReportDeliveryChannelArgs>) {
        this.reportDeliveryChannel = value
    }

    /**
     * @param value An object that identifies the report template for the report. Reports are built using a report template. Detailed below.
     */
    @JvmName("qjesseasnwkcohya")
    public suspend fun reportSetting(`value`: Output<ReportPlanReportSettingArgs>) {
        this.reportSetting = value
    }

    /**
     * @param value Metadata that you can assign to help organize the report plans you create. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bsvofrslaxntkosc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description of the report plan with a maximum of 1,024 characters
     */
    @JvmName("iddhshtgkhfikiwy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The unique name of the report plan. The name must be between 1 and 256 characters, starting with a letter, and consisting of letters, numbers, and underscores.
     */
    @JvmName("vegdpijstjmudujo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value An object that contains information about where and how to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports. Detailed below.
     */
    @JvmName("ktwdfuglijfcuhni")
    public suspend fun reportDeliveryChannel(`value`: ReportPlanReportDeliveryChannelArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reportDeliveryChannel = mapped
    }

    /**
     * @param argument An object that contains information about where and how to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports. Detailed below.
     */
    @JvmName("iipawylaiuoqtkat")
    public suspend
    fun reportDeliveryChannel(argument: suspend ReportPlanReportDeliveryChannelArgsBuilder.() -> Unit) {
        val toBeMapped = ReportPlanReportDeliveryChannelArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.reportDeliveryChannel = mapped
    }

    /**
     * @param value An object that identifies the report template for the report. Reports are built using a report template. Detailed below.
     */
    @JvmName("uywwxsbcljnithbq")
    public suspend fun reportSetting(`value`: ReportPlanReportSettingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reportSetting = mapped
    }

    /**
     * @param argument An object that identifies the report template for the report. Reports are built using a report template. Detailed below.
     */
    @JvmName("mhnrhaxnshcpkubd")
    public suspend
    fun reportSetting(argument: suspend ReportPlanReportSettingArgsBuilder.() -> Unit) {
        val toBeMapped = ReportPlanReportSettingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.reportSetting = mapped
    }

    /**
     * @param value Metadata that you can assign to help organize the report plans you create. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("igbphstctdiqvmhq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Metadata that you can assign to help organize the report plans you create. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gnkhfjexykqbeaaq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ReportPlanArgs = ReportPlanArgs(
        description = description,
        name = name,
        reportDeliveryChannel = reportDeliveryChannel,
        reportSetting = reportSetting,
        tags = tags,
    )
}
