@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin

import com.pulumi.aws.backup.kotlin.outputs.SelectionCondition
import com.pulumi.aws.backup.kotlin.outputs.SelectionSelectionTag
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.backup.kotlin.outputs.SelectionCondition.Companion.toKotlin as selectionConditionToKotlin
import com.pulumi.aws.backup.kotlin.outputs.SelectionSelectionTag.Companion.toKotlin as selectionSelectionTagToKotlin

/**
 * Builder for [Selection].
 */
@PulumiTagMarker
public class SelectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SelectionArgs = SelectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SelectionArgsBuilder.() -> Unit) {
        val builder = SelectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Selection {
        val builtJavaResource = com.pulumi.aws.backup.Selection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Selection(builtJavaResource)
    }
}

/**
 * Manages selection conditions for AWS Backup plan resources.
 * ## Example Usage
 * ### IAM Role
 * > For more information about creating and managing IAM Roles for backups and restores, see the [AWS Backup Developer Guide](https://docs.aws.amazon.com/aws-backup/latest/devguide/iam-service-roles.html).
 * The below example creates an IAM role with the default managed IAM Policy for allowing AWS Backup to create backups.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.backup.Selection;
 * import com.pulumi.aws.backup.SelectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("backup.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleRolePolicyAttachment = new RolePolicyAttachment("exampleRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AWSBackupServiceRolePolicyForBackup")
 *             .role(exampleRole.name())
 *             .build());
 *         var exampleSelection = new Selection("exampleSelection", SelectionArgs.builder()
 *             .iamRoleArn(exampleRole.arn())
 *             .build());
 *     }
 * }
 * ```
 * ### Selecting Backups By Tag
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.backup.Selection;
 * import com.pulumi.aws.backup.SelectionArgs;
 * import com.pulumi.aws.backup.inputs.SelectionSelectionTagArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Selection("example", SelectionArgs.builder()
 *             .iamRoleArn(aws_iam_role.example().arn())
 *             .planId(aws_backup_plan.example().id())
 *             .selectionTags(SelectionSelectionTagArgs.builder()
 *                 .type("STRINGEQUALS")
 *                 .key("foo")
 *                 .value("bar")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Selecting Backups By Conditions
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.backup.Selection;
 * import com.pulumi.aws.backup.SelectionArgs;
 * import com.pulumi.aws.backup.inputs.SelectionConditionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Selection("example", SelectionArgs.builder()
 *             .iamRoleArn(aws_iam_role.example().arn())
 *             .planId(aws_backup_plan.example().id())
 *             .resources("*")
 *             .conditions(SelectionConditionArgs.builder()
 *                 .stringEquals(SelectionConditionStringEqualArgs.builder()
 *                     .key("aws:ResourceTag/Component")
 *                     .value("rds")
 *                     .build())
 *                 .stringLikes(SelectionConditionStringLikeArgs.builder()
 *                     .key("aws:ResourceTag/Application")
 *                     .value("app*")
 *                     .build())
 *                 .stringNotEquals(SelectionConditionStringNotEqualArgs.builder()
 *                     .key("aws:ResourceTag/Backup")
 *                     .value("false")
 *                     .build())
 *                 .stringNotLikes(SelectionConditionStringNotLikeArgs.builder()
 *                     .key("aws:ResourceTag/Environment")
 *                     .value("test*")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Selecting Backups By Resource
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.backup.Selection;
 * import com.pulumi.aws.backup.SelectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Selection("example", SelectionArgs.builder()
 *             .iamRoleArn(aws_iam_role.example().arn())
 *             .planId(aws_backup_plan.example().id())
 *             .resources(
 *                 aws_db_instance.example().arn(),
 *                 aws_ebs_volume.example().arn(),
 *                 aws_efs_file_system.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ### Selecting Backups By Not Resource
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.backup.Selection;
 * import com.pulumi.aws.backup.SelectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Selection("example", SelectionArgs.builder()
 *             .iamRoleArn(aws_iam_role.example().arn())
 *             .planId(aws_backup_plan.example().id())
 *             .notResources(
 *                 aws_db_instance.example().arn(),
 *                 aws_ebs_volume.example().arn(),
 *                 aws_efs_file_system.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Backup selection using the role plan_id and id separated by `|`. For example:
 * ```sh
 *  $ pulumi import aws:backup/selection:Selection example plan-id|selection-id
 * ```
 *
 */
public class Selection internal constructor(
    override val javaResource: com.pulumi.aws.backup.Selection,
) : KotlinCustomResource(javaResource, SelectionMapper) {
    /**
     * A list of conditions that you define to assign resources to your backup plans using tags.
     */
    public val conditions: Output<List<SelectionCondition>>
        get() = javaResource.conditions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    selectionConditionToKotlin(args0)
                })
            })
        })

    /**
     * The ARN of the IAM role that AWS Backup uses to authenticate when restoring and backing up the target resource. See the [AWS Backup Developer Guide](https://docs.aws.amazon.com/aws-backup/latest/devguide/access-control.html#managed-policies) for additional information about using AWS managed policies or creating custom policies attached to the IAM role.
     */
    public val iamRoleArn: Output<String>
        get() = javaResource.iamRoleArn().applyValue({ args0 -> args0 })

    /**
     * The display name of a resource selection document.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * An array of strings that either contain Amazon Resource Names (ARNs) or match patterns of resources to exclude from a backup plan.
     */
    public val notResources: Output<List<String>>
        get() = javaResource.notResources().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The backup plan ID to be associated with the selection of resources.
     */
    public val planId: Output<String>
        get() = javaResource.planId().applyValue({ args0 -> args0 })

    /**
     * An array of strings that either contain Amazon Resource Names (ARNs) or match patterns of resources to assign to a backup plan.
     */
    public val resources: Output<List<String>>?
        get() = javaResource.resources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Tag-based conditions used to specify a set of resources to assign to a backup plan.
     */
    public val selectionTags: Output<List<SelectionSelectionTag>>?
        get() = javaResource.selectionTags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        selectionSelectionTagToKotlin(args0)
                    })
                })
            }).orElse(null)
        })
}

public object SelectionMapper : ResourceMapper<Selection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.backup.Selection::class == javaResource::class

    override fun map(javaResource: Resource): Selection = Selection(
        javaResource as
            com.pulumi.aws.backup.Selection,
    )
}

/**
 * @see [Selection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Selection].
 */
public suspend fun selection(name: String, block: suspend SelectionResourceBuilder.() -> Unit):
    Selection {
    val builder = SelectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Selection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun selection(name: String): Selection {
    val builder = SelectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
