@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin

import com.pulumi.aws.backup.SelectionArgs.builder
import com.pulumi.aws.backup.kotlin.inputs.SelectionConditionArgs
import com.pulumi.aws.backup.kotlin.inputs.SelectionConditionArgsBuilder
import com.pulumi.aws.backup.kotlin.inputs.SelectionSelectionTagArgs
import com.pulumi.aws.backup.kotlin.inputs.SelectionSelectionTagArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Manages selection conditions for AWS Backup plan resources.
 * ## Example Usage
 * ### IAM Role
 * > For more information about creating and managing IAM Roles for backups and restores, see the [AWS Backup Developer Guide](https://docs.aws.amazon.com/aws-backup/latest/devguide/iam-service-roles.html).
 * The below example creates an IAM role with the default managed IAM Policy for allowing AWS Backup to create backups.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.backup.Selection;
 * import com.pulumi.aws.backup.SelectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("backup.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleRolePolicyAttachment = new RolePolicyAttachment("exampleRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AWSBackupServiceRolePolicyForBackup")
 *             .role(exampleRole.name())
 *             .build());
 *         var exampleSelection = new Selection("exampleSelection", SelectionArgs.builder()
 *             .iamRoleArn(exampleRole.arn())
 *             .build());
 *     }
 * }
 * ```
 * ### Selecting Backups By Tag
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.backup.Selection;
 * import com.pulumi.aws.backup.SelectionArgs;
 * import com.pulumi.aws.backup.inputs.SelectionSelectionTagArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Selection("example", SelectionArgs.builder()
 *             .iamRoleArn(aws_iam_role.example().arn())
 *             .planId(aws_backup_plan.example().id())
 *             .selectionTags(SelectionSelectionTagArgs.builder()
 *                 .type("STRINGEQUALS")
 *                 .key("foo")
 *                 .value("bar")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Selecting Backups By Conditions
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.backup.Selection;
 * import com.pulumi.aws.backup.SelectionArgs;
 * import com.pulumi.aws.backup.inputs.SelectionConditionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Selection("example", SelectionArgs.builder()
 *             .iamRoleArn(aws_iam_role.example().arn())
 *             .planId(aws_backup_plan.example().id())
 *             .resources("*")
 *             .conditions(SelectionConditionArgs.builder()
 *                 .stringEquals(SelectionConditionStringEqualArgs.builder()
 *                     .key("aws:ResourceTag/Component")
 *                     .value("rds")
 *                     .build())
 *                 .stringLikes(SelectionConditionStringLikeArgs.builder()
 *                     .key("aws:ResourceTag/Application")
 *                     .value("app*")
 *                     .build())
 *                 .stringNotEquals(SelectionConditionStringNotEqualArgs.builder()
 *                     .key("aws:ResourceTag/Backup")
 *                     .value("false")
 *                     .build())
 *                 .stringNotLikes(SelectionConditionStringNotLikeArgs.builder()
 *                     .key("aws:ResourceTag/Environment")
 *                     .value("test*")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Selecting Backups By Resource
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.backup.Selection;
 * import com.pulumi.aws.backup.SelectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Selection("example", SelectionArgs.builder()
 *             .iamRoleArn(aws_iam_role.example().arn())
 *             .planId(aws_backup_plan.example().id())
 *             .resources(
 *                 aws_db_instance.example().arn(),
 *                 aws_ebs_volume.example().arn(),
 *                 aws_efs_file_system.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ### Selecting Backups By Not Resource
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.backup.Selection;
 * import com.pulumi.aws.backup.SelectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Selection("example", SelectionArgs.builder()
 *             .iamRoleArn(aws_iam_role.example().arn())
 *             .planId(aws_backup_plan.example().id())
 *             .notResources(
 *                 aws_db_instance.example().arn(),
 *                 aws_ebs_volume.example().arn(),
 *                 aws_efs_file_system.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Backup selection using the role plan_id and id separated by `|`. For example:
 * ```sh
 *  $ pulumi import aws:backup/selection:Selection example plan-id|selection-id
 * ```
 * @property conditions A list of conditions that you define to assign resources to your backup plans using tags.
 * @property iamRoleArn The ARN of the IAM role that AWS Backup uses to authenticate when restoring and backing up the target resource. See the [AWS Backup Developer Guide](https://docs.aws.amazon.com/aws-backup/latest/devguide/access-control.html#managed-policies) for additional information about using AWS managed policies or creating custom policies attached to the IAM role.
 * @property name The display name of a resource selection document.
 * @property notResources An array of strings that either contain Amazon Resource Names (ARNs) or match patterns of resources to exclude from a backup plan.
 * @property planId The backup plan ID to be associated with the selection of resources.
 * @property resources An array of strings that either contain Amazon Resource Names (ARNs) or match patterns of resources to assign to a backup plan.
 * @property selectionTags Tag-based conditions used to specify a set of resources to assign to a backup plan.
 */
public data class SelectionArgs(
    public val conditions: Output<List<SelectionConditionArgs>>? = null,
    public val iamRoleArn: Output<String>? = null,
    public val name: Output<String>? = null,
    public val notResources: Output<List<String>>? = null,
    public val planId: Output<String>? = null,
    public val resources: Output<List<String>>? = null,
    public val selectionTags: Output<List<SelectionSelectionTagArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.backup.SelectionArgs> {
    override fun toJava(): com.pulumi.aws.backup.SelectionArgs =
        com.pulumi.aws.backup.SelectionArgs.builder()
            .conditions(
                conditions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .iamRoleArn(iamRoleArn?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .notResources(notResources?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .planId(planId?.applyValue({ args0 -> args0 }))
            .resources(resources?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .selectionTags(
                selectionTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SelectionArgs].
 */
@PulumiTagMarker
public class SelectionArgsBuilder internal constructor() {
    private var conditions: Output<List<SelectionConditionArgs>>? = null

    private var iamRoleArn: Output<String>? = null

    private var name: Output<String>? = null

    private var notResources: Output<List<String>>? = null

    private var planId: Output<String>? = null

    private var resources: Output<List<String>>? = null

    private var selectionTags: Output<List<SelectionSelectionTagArgs>>? = null

    /**
     * @param value A list of conditions that you define to assign resources to your backup plans using tags.
     */
    @JvmName("erbluuhuydqwdstj")
    public suspend fun conditions(`value`: Output<List<SelectionConditionArgs>>) {
        this.conditions = value
    }

    @JvmName("elklscvbhrltbbvm")
    public suspend fun conditions(vararg values: Output<SelectionConditionArgs>) {
        this.conditions = Output.all(values.asList())
    }

    /**
     * @param values A list of conditions that you define to assign resources to your backup plans using tags.
     */
    @JvmName("ltlqfdsldkhctmsw")
    public suspend fun conditions(values: List<Output<SelectionConditionArgs>>) {
        this.conditions = Output.all(values)
    }

    /**
     * @param value The ARN of the IAM role that AWS Backup uses to authenticate when restoring and backing up the target resource. See the [AWS Backup Developer Guide](https://docs.aws.amazon.com/aws-backup/latest/devguide/access-control.html#managed-policies) for additional information about using AWS managed policies or creating custom policies attached to the IAM role.
     */
    @JvmName("lxbcnfekbekfhfug")
    public suspend fun iamRoleArn(`value`: Output<String>) {
        this.iamRoleArn = value
    }

    /**
     * @param value The display name of a resource selection document.
     */
    @JvmName("eahsvfrynsyulxbu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value An array of strings that either contain Amazon Resource Names (ARNs) or match patterns of resources to exclude from a backup plan.
     */
    @JvmName("yarfesxwuxdbwsmm")
    public suspend fun notResources(`value`: Output<List<String>>) {
        this.notResources = value
    }

    @JvmName("rcnvhiaqrsjwumlr")
    public suspend fun notResources(vararg values: Output<String>) {
        this.notResources = Output.all(values.asList())
    }

    /**
     * @param values An array of strings that either contain Amazon Resource Names (ARNs) or match patterns of resources to exclude from a backup plan.
     */
    @JvmName("nigvpxefblrrhckm")
    public suspend fun notResources(values: List<Output<String>>) {
        this.notResources = Output.all(values)
    }

    /**
     * @param value The backup plan ID to be associated with the selection of resources.
     */
    @JvmName("flexcinqmklhjobu")
    public suspend fun planId(`value`: Output<String>) {
        this.planId = value
    }

    /**
     * @param value An array of strings that either contain Amazon Resource Names (ARNs) or match patterns of resources to assign to a backup plan.
     */
    @JvmName("nwdkbgqummfedors")
    public suspend fun resources(`value`: Output<List<String>>) {
        this.resources = value
    }

    @JvmName("yoqfwumxtcdmjdcv")
    public suspend fun resources(vararg values: Output<String>) {
        this.resources = Output.all(values.asList())
    }

    /**
     * @param values An array of strings that either contain Amazon Resource Names (ARNs) or match patterns of resources to assign to a backup plan.
     */
    @JvmName("ksjtnahuetjonvjo")
    public suspend fun resources(values: List<Output<String>>) {
        this.resources = Output.all(values)
    }

    /**
     * @param value Tag-based conditions used to specify a set of resources to assign to a backup plan.
     */
    @JvmName("rkeyuxryngurynri")
    public suspend fun selectionTags(`value`: Output<List<SelectionSelectionTagArgs>>) {
        this.selectionTags = value
    }

    @JvmName("rupqjweuonhwjwap")
    public suspend fun selectionTags(vararg values: Output<SelectionSelectionTagArgs>) {
        this.selectionTags = Output.all(values.asList())
    }

    /**
     * @param values Tag-based conditions used to specify a set of resources to assign to a backup plan.
     */
    @JvmName("ocvqryaiwhatfsyb")
    public suspend fun selectionTags(values: List<Output<SelectionSelectionTagArgs>>) {
        this.selectionTags = Output.all(values)
    }

    /**
     * @param value A list of conditions that you define to assign resources to your backup plans using tags.
     */
    @JvmName("qaxvjfqbletdpypr")
    public suspend fun conditions(`value`: List<SelectionConditionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conditions = mapped
    }

    /**
     * @param argument A list of conditions that you define to assign resources to your backup plans using tags.
     */
    @JvmName("mwsgnkuwplhcbhmp")
    public suspend fun conditions(argument: List<suspend SelectionConditionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SelectionConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.conditions = mapped
    }

    /**
     * @param argument A list of conditions that you define to assign resources to your backup plans using tags.
     */
    @JvmName("gypcfckbtrlolrel")
    public suspend fun conditions(vararg argument: suspend SelectionConditionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SelectionConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.conditions = mapped
    }

    /**
     * @param argument A list of conditions that you define to assign resources to your backup plans using tags.
     */
    @JvmName("opvplnlfbahxiyaf")
    public suspend fun conditions(argument: suspend SelectionConditionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SelectionConditionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.conditions = mapped
    }

    /**
     * @param values A list of conditions that you define to assign resources to your backup plans using tags.
     */
    @JvmName("jtnuqaahjrebssek")
    public suspend fun conditions(vararg values: SelectionConditionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.conditions = mapped
    }

    /**
     * @param value The ARN of the IAM role that AWS Backup uses to authenticate when restoring and backing up the target resource. See the [AWS Backup Developer Guide](https://docs.aws.amazon.com/aws-backup/latest/devguide/access-control.html#managed-policies) for additional information about using AWS managed policies or creating custom policies attached to the IAM role.
     */
    @JvmName("dhdtokqxqnhuyxgy")
    public suspend fun iamRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamRoleArn = mapped
    }

    /**
     * @param value The display name of a resource selection document.
     */
    @JvmName("fbgapdxayfxdjrtx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value An array of strings that either contain Amazon Resource Names (ARNs) or match patterns of resources to exclude from a backup plan.
     */
    @JvmName("vffwopsyexhhxtfb")
    public suspend fun notResources(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notResources = mapped
    }

    /**
     * @param values An array of strings that either contain Amazon Resource Names (ARNs) or match patterns of resources to exclude from a backup plan.
     */
    @JvmName("stvpgfopjiqhdbmp")
    public suspend fun notResources(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notResources = mapped
    }

    /**
     * @param value The backup plan ID to be associated with the selection of resources.
     */
    @JvmName("mokejnwidlpqlbdt")
    public suspend fun planId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.planId = mapped
    }

    /**
     * @param value An array of strings that either contain Amazon Resource Names (ARNs) or match patterns of resources to assign to a backup plan.
     */
    @JvmName("lsmymnnkntnvhcru")
    public suspend fun resources(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param values An array of strings that either contain Amazon Resource Names (ARNs) or match patterns of resources to assign to a backup plan.
     */
    @JvmName("mimgtqkwdoipgknl")
    public suspend fun resources(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param value Tag-based conditions used to specify a set of resources to assign to a backup plan.
     */
    @JvmName("ygrgrdtnrjjqkbex")
    public suspend fun selectionTags(`value`: List<SelectionSelectionTagArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selectionTags = mapped
    }

    /**
     * @param argument Tag-based conditions used to specify a set of resources to assign to a backup plan.
     */
    @JvmName("ldbkrtausbklbyht")
    public suspend
    fun selectionTags(argument: List<suspend SelectionSelectionTagArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SelectionSelectionTagArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.selectionTags = mapped
    }

    /**
     * @param argument Tag-based conditions used to specify a set of resources to assign to a backup plan.
     */
    @JvmName("bqxahpwrxqumqgyc")
    public suspend fun selectionTags(
        vararg
        argument: suspend SelectionSelectionTagArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SelectionSelectionTagArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.selectionTags = mapped
    }

    /**
     * @param argument Tag-based conditions used to specify a set of resources to assign to a backup plan.
     */
    @JvmName("pkyxhfvqxwkcfikd")
    public suspend fun selectionTags(argument: suspend SelectionSelectionTagArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SelectionSelectionTagArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.selectionTags = mapped
    }

    /**
     * @param values Tag-based conditions used to specify a set of resources to assign to a backup plan.
     */
    @JvmName("ufwdweresuissuod")
    public suspend fun selectionTags(vararg values: SelectionSelectionTagArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectionTags = mapped
    }

    internal fun build(): SelectionArgs = SelectionArgs(
        conditions = conditions,
        iamRoleArn = iamRoleArn,
        name = name,
        notResources = notResources,
        planId = planId,
        resources = resources,
        selectionTags = selectionTags,
    )
}
