@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Vault].
 */
@PulumiTagMarker
public class VaultResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VaultArgs = VaultArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VaultArgsBuilder.() -> Unit) {
        val builder = VaultArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Vault {
        val builtJavaResource = com.pulumi.aws.backup.Vault(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Vault(builtJavaResource)
    }
}

/**
 * Provides an AWS Backup vault resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.backup.Vault;
 * import com.pulumi.aws.backup.VaultArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Vault("example", VaultArgs.builder()
 *             .kmsKeyArn(aws_kms_key.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Backup vault using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:backup/vault:Vault test-vault TestVault
 * ```
 *
 */
public class Vault internal constructor(
    override val javaResource: com.pulumi.aws.backup.Vault,
) : KotlinCustomResource(javaResource, VaultMapper) {
    /**
     * The ARN of the vault.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A boolean that indicates that all recovery points stored in the vault are deleted so that the vault can be destroyed without error.
     */
    public val forceDestroy: Output<Boolean>?
        get() = javaResource.forceDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The server-side encryption key that is used to protect your backups.
     */
    public val kmsKeyArn: Output<String>
        get() = javaResource.kmsKeyArn().applyValue({ args0 -> args0 })

    /**
     * Name of the backup vault to create.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The number of recovery points that are stored in a backup vault.
     */
    public val recoveryPoints: Output<Int>
        get() = javaResource.recoveryPoints().applyValue({ args0 -> args0 })

    /**
     * Metadata that you can assign to help organize the resources that you create. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object VaultMapper : ResourceMapper<Vault> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.backup.Vault::class == javaResource::class

    override fun map(javaResource: Resource): Vault = Vault(
        javaResource as
            com.pulumi.aws.backup.Vault,
    )
}

/**
 * @see [Vault].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Vault].
 */
public suspend fun vault(name: String, block: suspend VaultResourceBuilder.() -> Unit): Vault {
    val builder = VaultResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Vault].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vault(name: String): Vault {
    val builder = VaultResourceBuilder()
    builder.name(name)
    return builder.build()
}
