@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [VaultNotifications].
 */
@PulumiTagMarker
public class VaultNotificationsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VaultNotificationsArgs = VaultNotificationsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VaultNotificationsArgsBuilder.() -> Unit) {
        val builder = VaultNotificationsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VaultNotifications {
        val builtJavaResource = com.pulumi.aws.backup.VaultNotifications(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VaultNotifications(builtJavaResource)
    }
}

/**
 * Provides an AWS Backup vault notifications resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.sns.TopicPolicy;
 * import com.pulumi.aws.sns.TopicPolicyArgs;
 * import com.pulumi.aws.backup.VaultNotifications;
 * import com.pulumi.aws.backup.VaultNotificationsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testTopic = new Topic("testTopic");
 *         final var testPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .policyId("__default_policy_ID")
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("SNS:Publish")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("backup.amazonaws.com")
 *                     .build())
 *                 .resources(testTopic.arn())
 *                 .sid("__default_statement_ID")
 *                 .build())
 *             .build());
 *         var testTopicPolicy = new TopicPolicy("testTopicPolicy", TopicPolicyArgs.builder()
 *             .arn(testTopic.arn())
 *             .policy(testPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(testPolicyDocument -> testPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var testVaultNotifications = new VaultNotifications("testVaultNotifications", VaultNotificationsArgs.builder()
 *             .backupVaultName("example_backup_vault")
 *             .snsTopicArn(testTopic.arn())
 *             .backupVaultEvents(
 *                 "BACKUP_JOB_STARTED",
 *                 "RESTORE_JOB_COMPLETED")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Backup vault notifications using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:backup/vaultNotifications:VaultNotifications test TestVault
 * ```
 *
 */
public class VaultNotifications internal constructor(
    override val javaResource: com.pulumi.aws.backup.VaultNotifications,
) : KotlinCustomResource(javaResource, VaultNotificationsMapper) {
    /**
     * The ARN of the vault.
     */
    public val backupVaultArn: Output<String>
        get() = javaResource.backupVaultArn().applyValue({ args0 -> args0 })

    /**
     * An array of events that indicate the status of jobs to back up resources to the backup vault.
     */
    public val backupVaultEvents: Output<List<String>>
        get() = javaResource.backupVaultEvents().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Name of the backup vault to add notifications for.
     */
    public val backupVaultName: Output<String>
        get() = javaResource.backupVaultName().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) that specifies the topic for a backup vault’s events
     */
    public val snsTopicArn: Output<String>
        get() = javaResource.snsTopicArn().applyValue({ args0 -> args0 })
}

public object VaultNotificationsMapper : ResourceMapper<VaultNotifications> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.backup.VaultNotifications::class == javaResource::class

    override fun map(javaResource: Resource): VaultNotifications = VaultNotifications(
        javaResource as
            com.pulumi.aws.backup.VaultNotifications,
    )
}

/**
 * @see [VaultNotifications].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VaultNotifications].
 */
public suspend fun vaultNotifications(
    name: String,
    block: suspend VaultNotificationsResourceBuilder.() -> Unit,
): VaultNotifications {
    val builder = VaultNotificationsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VaultNotifications].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vaultNotifications(name: String): VaultNotifications {
    val builder = VaultNotificationsResourceBuilder()
    builder.name(name)
    return builder.build()
}
