@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin

import com.pulumi.aws.backup.VaultNotificationsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an AWS Backup vault notifications resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.sns.TopicPolicy;
 * import com.pulumi.aws.sns.TopicPolicyArgs;
 * import com.pulumi.aws.backup.VaultNotifications;
 * import com.pulumi.aws.backup.VaultNotificationsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testTopic = new Topic("testTopic");
 *         final var testPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .policyId("__default_policy_ID")
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("SNS:Publish")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("backup.amazonaws.com")
 *                     .build())
 *                 .resources(testTopic.arn())
 *                 .sid("__default_statement_ID")
 *                 .build())
 *             .build());
 *         var testTopicPolicy = new TopicPolicy("testTopicPolicy", TopicPolicyArgs.builder()
 *             .arn(testTopic.arn())
 *             .policy(testPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(testPolicyDocument -> testPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var testVaultNotifications = new VaultNotifications("testVaultNotifications", VaultNotificationsArgs.builder()
 *             .backupVaultName("example_backup_vault")
 *             .snsTopicArn(testTopic.arn())
 *             .backupVaultEvents(
 *                 "BACKUP_JOB_STARTED",
 *                 "RESTORE_JOB_COMPLETED")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Backup vault notifications using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:backup/vaultNotifications:VaultNotifications test TestVault
 * ```
 * @property backupVaultEvents An array of events that indicate the status of jobs to back up resources to the backup vault.
 * @property backupVaultName Name of the backup vault to add notifications for.
 * @property snsTopicArn The Amazon Resource Name (ARN) that specifies the topic for a backup vault’s events
 */
public data class VaultNotificationsArgs(
    public val backupVaultEvents: Output<List<String>>? = null,
    public val backupVaultName: Output<String>? = null,
    public val snsTopicArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.backup.VaultNotificationsArgs> {
    override fun toJava(): com.pulumi.aws.backup.VaultNotificationsArgs =
        com.pulumi.aws.backup.VaultNotificationsArgs.builder()
            .backupVaultEvents(backupVaultEvents?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .backupVaultName(backupVaultName?.applyValue({ args0 -> args0 }))
            .snsTopicArn(snsTopicArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VaultNotificationsArgs].
 */
@PulumiTagMarker
public class VaultNotificationsArgsBuilder internal constructor() {
    private var backupVaultEvents: Output<List<String>>? = null

    private var backupVaultName: Output<String>? = null

    private var snsTopicArn: Output<String>? = null

    /**
     * @param value An array of events that indicate the status of jobs to back up resources to the backup vault.
     */
    @JvmName("veufhaiildbgmogf")
    public suspend fun backupVaultEvents(`value`: Output<List<String>>) {
        this.backupVaultEvents = value
    }

    @JvmName("sadhvxrfyusxmqld")
    public suspend fun backupVaultEvents(vararg values: Output<String>) {
        this.backupVaultEvents = Output.all(values.asList())
    }

    /**
     * @param values An array of events that indicate the status of jobs to back up resources to the backup vault.
     */
    @JvmName("qqwwumboklmaxkif")
    public suspend fun backupVaultEvents(values: List<Output<String>>) {
        this.backupVaultEvents = Output.all(values)
    }

    /**
     * @param value Name of the backup vault to add notifications for.
     */
    @JvmName("dypauvwpvshwasqo")
    public suspend fun backupVaultName(`value`: Output<String>) {
        this.backupVaultName = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) that specifies the topic for a backup vault’s events
     */
    @JvmName("jxcutaibwlyegkrq")
    public suspend fun snsTopicArn(`value`: Output<String>) {
        this.snsTopicArn = value
    }

    /**
     * @param value An array of events that indicate the status of jobs to back up resources to the backup vault.
     */
    @JvmName("wndvavpwbkeswfuk")
    public suspend fun backupVaultEvents(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupVaultEvents = mapped
    }

    /**
     * @param values An array of events that indicate the status of jobs to back up resources to the backup vault.
     */
    @JvmName("ixthjkuwrikrpxek")
    public suspend fun backupVaultEvents(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupVaultEvents = mapped
    }

    /**
     * @param value Name of the backup vault to add notifications for.
     */
    @JvmName("uhauptdqocjmjkep")
    public suspend fun backupVaultName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupVaultName = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) that specifies the topic for a backup vault’s events
     */
    @JvmName("wbopuxdpwwbbetsg")
    public suspend fun snsTopicArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snsTopicArn = mapped
    }

    internal fun build(): VaultNotificationsArgs = VaultNotificationsArgs(
        backupVaultEvents = backupVaultEvents,
        backupVaultName = backupVaultName,
        snsTopicArn = snsTopicArn,
    )
}
