@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VaultPolicy].
 */
@PulumiTagMarker
public class VaultPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VaultPolicyArgs = VaultPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VaultPolicyArgsBuilder.() -> Unit) {
        val builder = VaultPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VaultPolicy {
        val builtJavaResource = com.pulumi.aws.backup.VaultPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VaultPolicy(builtJavaResource)
    }
}

/**
 * Provides an AWS Backup vault policy resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.backup.Vault;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.backup.VaultPolicy;
 * import com.pulumi.aws.backup.VaultPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleVault = new Vault("exampleVault");
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("*")
 *                     .build())
 *                 .actions(
 *                     "backup:DescribeBackupVault",
 *                     "backup:DeleteBackupVault",
 *                     "backup:PutBackupVaultAccessPolicy",
 *                     "backup:DeleteBackupVaultAccessPolicy",
 *                     "backup:GetBackupVaultAccessPolicy",
 *                     "backup:StartBackupJob",
 *                     "backup:GetBackupVaultNotifications",
 *                     "backup:PutBackupVaultNotifications")
 *                 .resources(exampleVault.arn())
 *                 .build())
 *             .build());
 *         var exampleVaultPolicy = new VaultPolicy("exampleVaultPolicy", VaultPolicyArgs.builder()
 *             .backupVaultName(exampleVault.name())
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(examplePolicyDocument -> examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Backup vault policy using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:backup/vaultPolicy:VaultPolicy test TestVault
 * ```
 *
 */
public class VaultPolicy internal constructor(
    override val javaResource: com.pulumi.aws.backup.VaultPolicy,
) : KotlinCustomResource(javaResource, VaultPolicyMapper) {
    /**
     * The ARN of the vault.
     */
    public val backupVaultArn: Output<String>
        get() = javaResource.backupVaultArn().applyValue({ args0 -> args0 })

    /**
     * Name of the backup vault to add policy for.
     */
    public val backupVaultName: Output<String>
        get() = javaResource.backupVaultName().applyValue({ args0 -> args0 })

    /**
     * The backup vault access policy document in JSON format.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })
}

public object VaultPolicyMapper : ResourceMapper<VaultPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.backup.VaultPolicy::class == javaResource::class

    override fun map(javaResource: Resource): VaultPolicy = VaultPolicy(
        javaResource as
            com.pulumi.aws.backup.VaultPolicy,
    )
}

/**
 * @see [VaultPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VaultPolicy].
 */
public suspend fun vaultPolicy(name: String, block: suspend VaultPolicyResourceBuilder.() -> Unit):
    VaultPolicy {
    val builder = VaultPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VaultPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vaultPolicy(name: String): VaultPolicy {
    val builder = VaultPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
