@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin

import com.pulumi.aws.backup.VaultPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an AWS Backup vault policy resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.backup.Vault;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.backup.VaultPolicy;
 * import com.pulumi.aws.backup.VaultPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleVault = new Vault("exampleVault");
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("*")
 *                     .build())
 *                 .actions(
 *                     "backup:DescribeBackupVault",
 *                     "backup:DeleteBackupVault",
 *                     "backup:PutBackupVaultAccessPolicy",
 *                     "backup:DeleteBackupVaultAccessPolicy",
 *                     "backup:GetBackupVaultAccessPolicy",
 *                     "backup:StartBackupJob",
 *                     "backup:GetBackupVaultNotifications",
 *                     "backup:PutBackupVaultNotifications")
 *                 .resources(exampleVault.arn())
 *                 .build())
 *             .build());
 *         var exampleVaultPolicy = new VaultPolicy("exampleVaultPolicy", VaultPolicyArgs.builder()
 *             .backupVaultName(exampleVault.name())
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(examplePolicyDocument -> examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Backup vault policy using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:backup/vaultPolicy:VaultPolicy test TestVault
 * ```
 * @property backupVaultName Name of the backup vault to add policy for.
 * @property policy The backup vault access policy document in JSON format.
 */
public data class VaultPolicyArgs(
    public val backupVaultName: Output<String>? = null,
    public val policy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.backup.VaultPolicyArgs> {
    override fun toJava(): com.pulumi.aws.backup.VaultPolicyArgs =
        com.pulumi.aws.backup.VaultPolicyArgs.builder()
            .backupVaultName(backupVaultName?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VaultPolicyArgs].
 */
@PulumiTagMarker
public class VaultPolicyArgsBuilder internal constructor() {
    private var backupVaultName: Output<String>? = null

    private var policy: Output<String>? = null

    /**
     * @param value Name of the backup vault to add policy for.
     */
    @JvmName("bdkbkygyshepwexe")
    public suspend fun backupVaultName(`value`: Output<String>) {
        this.backupVaultName = value
    }

    /**
     * @param value The backup vault access policy document in JSON format.
     */
    @JvmName("ytxnqubbvfeuqxfm")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value Name of the backup vault to add policy for.
     */
    @JvmName("opvdqoghicepifgm")
    public suspend fun backupVaultName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupVaultName = mapped
    }

    /**
     * @param value The backup vault access policy document in JSON format.
     */
    @JvmName("aoploymqoagijsbq")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    internal fun build(): VaultPolicyArgs = VaultPolicyArgs(
        backupVaultName = backupVaultName,
        policy = policy,
    )
}
