@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.inputs

import com.pulumi.aws.backup.inputs.FrameworkControlArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property inputParameters One or more input parameter blocks. An example of a control with two parameters is: "backup plan frequency is at least daily and the retention period is at least 1 year". The first parameter is daily. The second parameter is 1 year. Detailed below.
 * @property name The name of a control. This name is between 1 and 256 characters.
 * @property scope The scope of a control. The control scope defines what the control will evaluate. Three examples of control scopes are: a specific backup plan, all backup plans with a specific tag, or all backup plans. Detailed below.
 */
public data class FrameworkControlArgs(
    public val inputParameters: Output<List<FrameworkControlInputParameterArgs>>? = null,
    public val name: Output<String>,
    public val scope: Output<FrameworkControlScopeArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.backup.inputs.FrameworkControlArgs> {
    override fun toJava(): com.pulumi.aws.backup.inputs.FrameworkControlArgs =
        com.pulumi.aws.backup.inputs.FrameworkControlArgs.builder()
            .inputParameters(
                inputParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [FrameworkControlArgs].
 */
@PulumiTagMarker
public class FrameworkControlArgsBuilder internal constructor() {
    private var inputParameters: Output<List<FrameworkControlInputParameterArgs>>? = null

    private var name: Output<String>? = null

    private var scope: Output<FrameworkControlScopeArgs>? = null

    /**
     * @param value One or more input parameter blocks. An example of a control with two parameters is: "backup plan frequency is at least daily and the retention period is at least 1 year". The first parameter is daily. The second parameter is 1 year. Detailed below.
     */
    @JvmName("kalpbpesjwkdqqpy")
    public suspend fun inputParameters(`value`: Output<List<FrameworkControlInputParameterArgs>>) {
        this.inputParameters = value
    }

    @JvmName("hkhmpreyurunwvhj")
    public suspend fun inputParameters(vararg values: Output<FrameworkControlInputParameterArgs>) {
        this.inputParameters = Output.all(values.asList())
    }

    /**
     * @param values One or more input parameter blocks. An example of a control with two parameters is: "backup plan frequency is at least daily and the retention period is at least 1 year". The first parameter is daily. The second parameter is 1 year. Detailed below.
     */
    @JvmName("byqsbysrxtlyujmk")
    public suspend fun inputParameters(values: List<Output<FrameworkControlInputParameterArgs>>) {
        this.inputParameters = Output.all(values)
    }

    /**
     * @param value The name of a control. This name is between 1 and 256 characters.
     */
    @JvmName("qmonlqhmskntfrmf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The scope of a control. The control scope defines what the control will evaluate. Three examples of control scopes are: a specific backup plan, all backup plans with a specific tag, or all backup plans. Detailed below.
     */
    @JvmName("vkxrqvxmgegwmuil")
    public suspend fun scope(`value`: Output<FrameworkControlScopeArgs>) {
        this.scope = value
    }

    /**
     * @param value One or more input parameter blocks. An example of a control with two parameters is: "backup plan frequency is at least daily and the retention period is at least 1 year". The first parameter is daily. The second parameter is 1 year. Detailed below.
     */
    @JvmName("lhfjghqpnllalipw")
    public suspend fun inputParameters(`value`: List<FrameworkControlInputParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputParameters = mapped
    }

    /**
     * @param argument One or more input parameter blocks. An example of a control with two parameters is: "backup plan frequency is at least daily and the retention period is at least 1 year". The first parameter is daily. The second parameter is 1 year. Detailed below.
     */
    @JvmName("hyekfhkmegtgnebj")
    public suspend
    fun inputParameters(argument: List<suspend FrameworkControlInputParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FrameworkControlInputParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.inputParameters = mapped
    }

    /**
     * @param argument One or more input parameter blocks. An example of a control with two parameters is: "backup plan frequency is at least daily and the retention period is at least 1 year". The first parameter is daily. The second parameter is 1 year. Detailed below.
     */
    @JvmName("dmtilbhtjmwftatl")
    public suspend fun inputParameters(
        vararg
        argument: suspend FrameworkControlInputParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FrameworkControlInputParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.inputParameters = mapped
    }

    /**
     * @param argument One or more input parameter blocks. An example of a control with two parameters is: "backup plan frequency is at least daily and the retention period is at least 1 year". The first parameter is daily. The second parameter is 1 year. Detailed below.
     */
    @JvmName("sgnusmkfvylvdbly")
    public suspend
    fun inputParameters(argument: suspend FrameworkControlInputParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FrameworkControlInputParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.inputParameters = mapped
    }

    /**
     * @param values One or more input parameter blocks. An example of a control with two parameters is: "backup plan frequency is at least daily and the retention period is at least 1 year". The first parameter is daily. The second parameter is 1 year. Detailed below.
     */
    @JvmName("butllvrnbbncqhnf")
    public suspend fun inputParameters(vararg values: FrameworkControlInputParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputParameters = mapped
    }

    /**
     * @param value The name of a control. This name is between 1 and 256 characters.
     */
    @JvmName("gioahykrnqrnxlfs")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The scope of a control. The control scope defines what the control will evaluate. Three examples of control scopes are: a specific backup plan, all backup plans with a specific tag, or all backup plans. Detailed below.
     */
    @JvmName("wqbctlnonddksjli")
    public suspend fun scope(`value`: FrameworkControlScopeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param argument The scope of a control. The control scope defines what the control will evaluate. Three examples of control scopes are: a specific backup plan, all backup plans with a specific tag, or all backup plans. Detailed below.
     */
    @JvmName("cmwliervuaexajby")
    public suspend fun scope(argument: suspend FrameworkControlScopeArgsBuilder.() -> Unit) {
        val toBeMapped = FrameworkControlScopeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scope = mapped
    }

    internal fun build(): FrameworkControlArgs = FrameworkControlArgs(
        inputParameters = inputParameters,
        name = name ?: throw PulumiNullFieldException("name"),
        scope = scope,
    )
}
