@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.inputs

import com.pulumi.aws.backup.inputs.FrameworkControlInputParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of a parameter, for example, BackupPlanFrequency.
 * @property value The value of parameter, for example, hourly.
 */
public data class FrameworkControlInputParameterArgs(
    public val name: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.backup.inputs.FrameworkControlInputParameterArgs> {
    override fun toJava(): com.pulumi.aws.backup.inputs.FrameworkControlInputParameterArgs =
        com.pulumi.aws.backup.inputs.FrameworkControlInputParameterArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FrameworkControlInputParameterArgs].
 */
@PulumiTagMarker
public class FrameworkControlInputParameterArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The name of a parameter, for example, BackupPlanFrequency.
     */
    @JvmName("sxsglbyosxbwsmod")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The value of parameter, for example, hourly.
     */
    @JvmName("pbksgjwbfrrpdrkh")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The name of a parameter, for example, BackupPlanFrequency.
     */
    @JvmName("huqwbbpjeuqpjlny")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The value of parameter, for example, hourly.
     */
    @JvmName("oyhxhtilaytxwsoj")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): FrameworkControlInputParameterArgs = FrameworkControlInputParameterArgs(
        name = name,
        `value` = `value`,
    )
}
