@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.inputs

import com.pulumi.aws.backup.inputs.GetPlanPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPlan.
 * @property planId Backup plan ID.
 * @property tags Metadata that you can assign to help organize the plans you create.
 */
public data class GetPlanPlainArgs(
    public val planId: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.backup.inputs.GetPlanPlainArgs> {
    override fun toJava(): com.pulumi.aws.backup.inputs.GetPlanPlainArgs =
        com.pulumi.aws.backup.inputs.GetPlanPlainArgs.builder()
            .planId(planId.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetPlanPlainArgs].
 */
@PulumiTagMarker
public class GetPlanPlainArgsBuilder internal constructor() {
    private var planId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Backup plan ID.
     */
    @JvmName("xgesljtluvnrblai")
    public suspend fun planId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.planId = mapped
    }

    /**
     * @param value Metadata that you can assign to help organize the plans you create.
     */
    @JvmName("vwloyfyrmulpvllw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Metadata that you can assign to help organize the plans you create.
     */
    @JvmName("ysrhvdipluncpnxt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetPlanPlainArgs = GetPlanPlainArgs(
        planId = planId ?: throw PulumiNullFieldException("planId"),
        tags = tags,
    )
}
