@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.inputs

import com.pulumi.aws.backup.inputs.GetReportPlanPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getReportPlan.
 * @property name Backup report plan name.
 * @property tags Metadata that you can assign to help organize the report plans you create.
 */
public data class GetReportPlanPlainArgs(
    public val name: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.backup.inputs.GetReportPlanPlainArgs> {
    override fun toJava(): com.pulumi.aws.backup.inputs.GetReportPlanPlainArgs =
        com.pulumi.aws.backup.inputs.GetReportPlanPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetReportPlanPlainArgs].
 */
@PulumiTagMarker
public class GetReportPlanPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Backup report plan name.
     */
    @JvmName("bmbkvhlhvbxvqocb")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Metadata that you can assign to help organize the report plans you create.
     */
    @JvmName("nlncuiobyarlsahc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Metadata that you can assign to help organize the report plans you create.
     */
    @JvmName("aqviwcqtsmatrwop")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetReportPlanPlainArgs = GetReportPlanPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        tags = tags,
    )
}
