@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.inputs

import com.pulumi.aws.backup.inputs.GetSelectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSelection.
 * @property planId Backup plan ID associated with the selection of resources.
 * @property selectionId Backup selection ID.
 */
public data class GetSelectionPlainArgs(
    public val planId: String,
    public val selectionId: String,
) : ConvertibleToJava<com.pulumi.aws.backup.inputs.GetSelectionPlainArgs> {
    override fun toJava(): com.pulumi.aws.backup.inputs.GetSelectionPlainArgs =
        com.pulumi.aws.backup.inputs.GetSelectionPlainArgs.builder()
            .planId(planId.let({ args0 -> args0 }))
            .selectionId(selectionId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSelectionPlainArgs].
 */
@PulumiTagMarker
public class GetSelectionPlainArgsBuilder internal constructor() {
    private var planId: String? = null

    private var selectionId: String? = null

    /**
     * @param value Backup plan ID associated with the selection of resources.
     */
    @JvmName("gperejnneynrswbv")
    public suspend fun planId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.planId = mapped
    }

    /**
     * @param value Backup selection ID.
     */
    @JvmName("jjityeyuyvjsyfyf")
    public suspend fun selectionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.selectionId = mapped
    }

    internal fun build(): GetSelectionPlainArgs = GetSelectionPlainArgs(
        planId = planId ?: throw PulumiNullFieldException("planId"),
        selectionId = selectionId ?: throw PulumiNullFieldException("selectionId"),
    )
}
