@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.inputs

import com.pulumi.aws.backup.inputs.PlanRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property completionWindow The amount of time in minutes AWS Backup attempts a backup before canceling the job and returning an error.
 * @property copyActions Configuration block(s) with copy operation settings. Detailed below.
 * @property enableContinuousBackup Enable continuous backups for supported resources.
 * @property lifecycle The lifecycle defines when a protected resource is transitioned to cold storage and when it expires.  Fields documented below.
 * @property recoveryPointTags Metadata that you can assign to help organize the resources that you create.
 * @property ruleName An display name for a backup rule.
 * @property schedule A CRON expression specifying when AWS Backup initiates a backup job.
 * @property startWindow The amount of time in minutes before beginning a backup.
 * @property targetVaultName The name of a logical container where backups are stored.
 */
public data class PlanRuleArgs(
    public val completionWindow: Output<Int>? = null,
    public val copyActions: Output<List<PlanRuleCopyActionArgs>>? = null,
    public val enableContinuousBackup: Output<Boolean>? = null,
    public val lifecycle: Output<PlanRuleLifecycleArgs>? = null,
    public val recoveryPointTags: Output<Map<String, String>>? = null,
    public val ruleName: Output<String>,
    public val schedule: Output<String>? = null,
    public val startWindow: Output<Int>? = null,
    public val targetVaultName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.backup.inputs.PlanRuleArgs> {
    override fun toJava(): com.pulumi.aws.backup.inputs.PlanRuleArgs =
        com.pulumi.aws.backup.inputs.PlanRuleArgs.builder()
            .completionWindow(completionWindow?.applyValue({ args0 -> args0 }))
            .copyActions(
                copyActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enableContinuousBackup(enableContinuousBackup?.applyValue({ args0 -> args0 }))
            .lifecycle(lifecycle?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .recoveryPointTags(
                recoveryPointTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .ruleName(ruleName.applyValue({ args0 -> args0 }))
            .schedule(schedule?.applyValue({ args0 -> args0 }))
            .startWindow(startWindow?.applyValue({ args0 -> args0 }))
            .targetVaultName(targetVaultName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PlanRuleArgs].
 */
@PulumiTagMarker
public class PlanRuleArgsBuilder internal constructor() {
    private var completionWindow: Output<Int>? = null

    private var copyActions: Output<List<PlanRuleCopyActionArgs>>? = null

    private var enableContinuousBackup: Output<Boolean>? = null

    private var lifecycle: Output<PlanRuleLifecycleArgs>? = null

    private var recoveryPointTags: Output<Map<String, String>>? = null

    private var ruleName: Output<String>? = null

    private var schedule: Output<String>? = null

    private var startWindow: Output<Int>? = null

    private var targetVaultName: Output<String>? = null

    /**
     * @param value The amount of time in minutes AWS Backup attempts a backup before canceling the job and returning an error.
     */
    @JvmName("pibmkxgnhoprihfn")
    public suspend fun completionWindow(`value`: Output<Int>) {
        this.completionWindow = value
    }

    /**
     * @param value Configuration block(s) with copy operation settings. Detailed below.
     */
    @JvmName("yagmxlxhbtgnaksn")
    public suspend fun copyActions(`value`: Output<List<PlanRuleCopyActionArgs>>) {
        this.copyActions = value
    }

    @JvmName("mdgfmtrphglmwbtl")
    public suspend fun copyActions(vararg values: Output<PlanRuleCopyActionArgs>) {
        this.copyActions = Output.all(values.asList())
    }

    /**
     * @param values Configuration block(s) with copy operation settings. Detailed below.
     */
    @JvmName("ghglogkdmppycmvo")
    public suspend fun copyActions(values: List<Output<PlanRuleCopyActionArgs>>) {
        this.copyActions = Output.all(values)
    }

    /**
     * @param value Enable continuous backups for supported resources.
     */
    @JvmName("qpancueyrkthqfoa")
    public suspend fun enableContinuousBackup(`value`: Output<Boolean>) {
        this.enableContinuousBackup = value
    }

    /**
     * @param value The lifecycle defines when a protected resource is transitioned to cold storage and when it expires.  Fields documented below.
     */
    @JvmName("gtuslymcpbxxrdvk")
    public suspend fun lifecycle(`value`: Output<PlanRuleLifecycleArgs>) {
        this.lifecycle = value
    }

    /**
     * @param value Metadata that you can assign to help organize the resources that you create.
     */
    @JvmName("bjdcpebnoryvmfjv")
    public suspend fun recoveryPointTags(`value`: Output<Map<String, String>>) {
        this.recoveryPointTags = value
    }

    /**
     * @param value An display name for a backup rule.
     */
    @JvmName("pveutvlkgvhfboph")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value A CRON expression specifying when AWS Backup initiates a backup job.
     */
    @JvmName("yfloesvyrtnmorkp")
    public suspend fun schedule(`value`: Output<String>) {
        this.schedule = value
    }

    /**
     * @param value The amount of time in minutes before beginning a backup.
     */
    @JvmName("oqhjjaamyelkhlww")
    public suspend fun startWindow(`value`: Output<Int>) {
        this.startWindow = value
    }

    /**
     * @param value The name of a logical container where backups are stored.
     */
    @JvmName("qjsplxeyfpfflpjt")
    public suspend fun targetVaultName(`value`: Output<String>) {
        this.targetVaultName = value
    }

    /**
     * @param value The amount of time in minutes AWS Backup attempts a backup before canceling the job and returning an error.
     */
    @JvmName("lipxylrrsxpdxpht")
    public suspend fun completionWindow(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.completionWindow = mapped
    }

    /**
     * @param value Configuration block(s) with copy operation settings. Detailed below.
     */
    @JvmName("awymxnffmselnmqb")
    public suspend fun copyActions(`value`: List<PlanRuleCopyActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyActions = mapped
    }

    /**
     * @param argument Configuration block(s) with copy operation settings. Detailed below.
     */
    @JvmName("scxslgboybsnnbka")
    public suspend fun copyActions(argument: List<suspend PlanRuleCopyActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PlanRuleCopyActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.copyActions = mapped
    }

    /**
     * @param argument Configuration block(s) with copy operation settings. Detailed below.
     */
    @JvmName("tckimmfakobykmho")
    public suspend fun copyActions(
        vararg
        argument: suspend PlanRuleCopyActionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PlanRuleCopyActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.copyActions = mapped
    }

    /**
     * @param argument Configuration block(s) with copy operation settings. Detailed below.
     */
    @JvmName("huujcnndgropnfcr")
    public suspend fun copyActions(argument: suspend PlanRuleCopyActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PlanRuleCopyActionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.copyActions = mapped
    }

    /**
     * @param values Configuration block(s) with copy operation settings. Detailed below.
     */
    @JvmName("geirwomvvfmrbmfy")
    public suspend fun copyActions(vararg values: PlanRuleCopyActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.copyActions = mapped
    }

    /**
     * @param value Enable continuous backups for supported resources.
     */
    @JvmName("enfkeftmlidemvoa")
    public suspend fun enableContinuousBackup(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableContinuousBackup = mapped
    }

    /**
     * @param value The lifecycle defines when a protected resource is transitioned to cold storage and when it expires.  Fields documented below.
     */
    @JvmName("rruotkreocthybby")
    public suspend fun lifecycle(`value`: PlanRuleLifecycleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycle = mapped
    }

    /**
     * @param argument The lifecycle defines when a protected resource is transitioned to cold storage and when it expires.  Fields documented below.
     */
    @JvmName("fcslxejugssrulaf")
    public suspend fun lifecycle(argument: suspend PlanRuleLifecycleArgsBuilder.() -> Unit) {
        val toBeMapped = PlanRuleLifecycleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.lifecycle = mapped
    }

    /**
     * @param value Metadata that you can assign to help organize the resources that you create.
     */
    @JvmName("gbqhcgpdvpuugaeh")
    public suspend fun recoveryPointTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryPointTags = mapped
    }

    /**
     * @param values Metadata that you can assign to help organize the resources that you create.
     */
    @JvmName("adenstyhldpvvkrt")
    public fun recoveryPointTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recoveryPointTags = mapped
    }

    /**
     * @param value An display name for a backup rule.
     */
    @JvmName("vpbsbsuohqdwjwyd")
    public suspend fun ruleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    /**
     * @param value A CRON expression specifying when AWS Backup initiates a backup job.
     */
    @JvmName("eaxfqafitahfnonf")
    public suspend fun schedule(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param value The amount of time in minutes before beginning a backup.
     */
    @JvmName("amyeleqyejogemcf")
    public suspend fun startWindow(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startWindow = mapped
    }

    /**
     * @param value The name of a logical container where backups are stored.
     */
    @JvmName("pelrcpsfsifjccip")
    public suspend fun targetVaultName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetVaultName = mapped
    }

    internal fun build(): PlanRuleArgs = PlanRuleArgs(
        completionWindow = completionWindow,
        copyActions = copyActions,
        enableContinuousBackup = enableContinuousBackup,
        lifecycle = lifecycle,
        recoveryPointTags = recoveryPointTags,
        ruleName = ruleName ?: throw PulumiNullFieldException("ruleName"),
        schedule = schedule,
        startWindow = startWindow,
        targetVaultName = targetVaultName ?: throw PulumiNullFieldException("targetVaultName"),
    )
}
