@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.inputs

import com.pulumi.aws.backup.inputs.PlanRuleCopyActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property destinationVaultArn An Amazon Resource Name (ARN) that uniquely identifies the destination backup vault for the copied backup.
 * @property lifecycle The lifecycle defines when a protected resource is copied over to a backup vault and when it expires.  Fields documented above.
 */
public data class PlanRuleCopyActionArgs(
    public val destinationVaultArn: Output<String>,
    public val lifecycle: Output<PlanRuleCopyActionLifecycleArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.backup.inputs.PlanRuleCopyActionArgs> {
    override fun toJava(): com.pulumi.aws.backup.inputs.PlanRuleCopyActionArgs =
        com.pulumi.aws.backup.inputs.PlanRuleCopyActionArgs.builder()
            .destinationVaultArn(destinationVaultArn.applyValue({ args0 -> args0 }))
            .lifecycle(lifecycle?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PlanRuleCopyActionArgs].
 */
@PulumiTagMarker
public class PlanRuleCopyActionArgsBuilder internal constructor() {
    private var destinationVaultArn: Output<String>? = null

    private var lifecycle: Output<PlanRuleCopyActionLifecycleArgs>? = null

    /**
     * @param value An Amazon Resource Name (ARN) that uniquely identifies the destination backup vault for the copied backup.
     */
    @JvmName("pyqulkjppgispdie")
    public suspend fun destinationVaultArn(`value`: Output<String>) {
        this.destinationVaultArn = value
    }

    /**
     * @param value The lifecycle defines when a protected resource is copied over to a backup vault and when it expires.  Fields documented above.
     */
    @JvmName("vsehxjwfeibbjmra")
    public suspend fun lifecycle(`value`: Output<PlanRuleCopyActionLifecycleArgs>) {
        this.lifecycle = value
    }

    /**
     * @param value An Amazon Resource Name (ARN) that uniquely identifies the destination backup vault for the copied backup.
     */
    @JvmName("jmbuvtxiamlddsxj")
    public suspend fun destinationVaultArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationVaultArn = mapped
    }

    /**
     * @param value The lifecycle defines when a protected resource is copied over to a backup vault and when it expires.  Fields documented above.
     */
    @JvmName("ememkytbwujfqjdr")
    public suspend fun lifecycle(`value`: PlanRuleCopyActionLifecycleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycle = mapped
    }

    /**
     * @param argument The lifecycle defines when a protected resource is copied over to a backup vault and when it expires.  Fields documented above.
     */
    @JvmName("ljrskahtqnmlsvme")
    public suspend
    fun lifecycle(argument: suspend PlanRuleCopyActionLifecycleArgsBuilder.() -> Unit) {
        val toBeMapped = PlanRuleCopyActionLifecycleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.lifecycle = mapped
    }

    internal fun build(): PlanRuleCopyActionArgs = PlanRuleCopyActionArgs(
        destinationVaultArn = destinationVaultArn ?: throw PulumiNullFieldException("destinationVaultArn"),
        lifecycle = lifecycle,
    )
}
