@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.inputs

import com.pulumi.aws.backup.inputs.PlanRuleCopyActionLifecycleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property coldStorageAfter Specifies the number of days after creation that a recovery point is moved to cold storage.
 * @property deleteAfter Specifies the number of days after creation that a recovery point is deleted. Must be 90 days greater than `cold_storage_after`.
 */
public data class PlanRuleCopyActionLifecycleArgs(
    public val coldStorageAfter: Output<Int>? = null,
    public val deleteAfter: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.backup.inputs.PlanRuleCopyActionLifecycleArgs> {
    override fun toJava(): com.pulumi.aws.backup.inputs.PlanRuleCopyActionLifecycleArgs =
        com.pulumi.aws.backup.inputs.PlanRuleCopyActionLifecycleArgs.builder()
            .coldStorageAfter(coldStorageAfter?.applyValue({ args0 -> args0 }))
            .deleteAfter(deleteAfter?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PlanRuleCopyActionLifecycleArgs].
 */
@PulumiTagMarker
public class PlanRuleCopyActionLifecycleArgsBuilder internal constructor() {
    private var coldStorageAfter: Output<Int>? = null

    private var deleteAfter: Output<Int>? = null

    /**
     * @param value Specifies the number of days after creation that a recovery point is moved to cold storage.
     */
    @JvmName("avykdaiioriywhnl")
    public suspend fun coldStorageAfter(`value`: Output<Int>) {
        this.coldStorageAfter = value
    }

    /**
     * @param value Specifies the number of days after creation that a recovery point is deleted. Must be 90 days greater than `cold_storage_after`.
     */
    @JvmName("qwjimcdvnihwajmd")
    public suspend fun deleteAfter(`value`: Output<Int>) {
        this.deleteAfter = value
    }

    /**
     * @param value Specifies the number of days after creation that a recovery point is moved to cold storage.
     */
    @JvmName("cbkpohdbaidjdcbx")
    public suspend fun coldStorageAfter(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coldStorageAfter = mapped
    }

    /**
     * @param value Specifies the number of days after creation that a recovery point is deleted. Must be 90 days greater than `cold_storage_after`.
     */
    @JvmName("btxvoeaedsupofgy")
    public suspend fun deleteAfter(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteAfter = mapped
    }

    internal fun build(): PlanRuleCopyActionLifecycleArgs = PlanRuleCopyActionLifecycleArgs(
        coldStorageAfter = coldStorageAfter,
        deleteAfter = deleteAfter,
    )
}
