@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.inputs

import com.pulumi.aws.backup.inputs.ReportPlanReportSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property accounts Specifies the list of accounts a report covers.
 * @property frameworkArns Specifies the Amazon Resource Names (ARNs) of the frameworks a report covers.
 * @property numberOfFrameworks Specifies the number of frameworks a report covers.
 * @property organizationUnits Specifies the list of Organizational Units a report covers.
 * @property regions Specifies the list of regions a report covers.
 * @property reportTemplate Identifies the report template for the report. Reports are built using a report template. The report templates are: `RESOURCE_COMPLIANCE_REPORT` | `CONTROL_COMPLIANCE_REPORT` | `BACKUP_JOB_REPORT` | `COPY_JOB_REPORT` | `RESTORE_JOB_REPORT`.
 */
public data class ReportPlanReportSettingArgs(
    public val accounts: Output<List<String>>? = null,
    public val frameworkArns: Output<List<String>>? = null,
    public val numberOfFrameworks: Output<Int>? = null,
    public val organizationUnits: Output<List<String>>? = null,
    public val regions: Output<List<String>>? = null,
    public val reportTemplate: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.backup.inputs.ReportPlanReportSettingArgs> {
    override fun toJava(): com.pulumi.aws.backup.inputs.ReportPlanReportSettingArgs =
        com.pulumi.aws.backup.inputs.ReportPlanReportSettingArgs.builder()
            .accounts(accounts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .frameworkArns(frameworkArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .numberOfFrameworks(numberOfFrameworks?.applyValue({ args0 -> args0 }))
            .organizationUnits(organizationUnits?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .regions(regions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .reportTemplate(reportTemplate.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReportPlanReportSettingArgs].
 */
@PulumiTagMarker
public class ReportPlanReportSettingArgsBuilder internal constructor() {
    private var accounts: Output<List<String>>? = null

    private var frameworkArns: Output<List<String>>? = null

    private var numberOfFrameworks: Output<Int>? = null

    private var organizationUnits: Output<List<String>>? = null

    private var regions: Output<List<String>>? = null

    private var reportTemplate: Output<String>? = null

    /**
     * @param value Specifies the list of accounts a report covers.
     */
    @JvmName("ufhgmymlwgllktsg")
    public suspend fun accounts(`value`: Output<List<String>>) {
        this.accounts = value
    }

    @JvmName("jxwqsdofboohjvqr")
    public suspend fun accounts(vararg values: Output<String>) {
        this.accounts = Output.all(values.asList())
    }

    /**
     * @param values Specifies the list of accounts a report covers.
     */
    @JvmName("seduipfwsrfshwpk")
    public suspend fun accounts(values: List<Output<String>>) {
        this.accounts = Output.all(values)
    }

    /**
     * @param value Specifies the Amazon Resource Names (ARNs) of the frameworks a report covers.
     */
    @JvmName("cgbuwjejiqsnligw")
    public suspend fun frameworkArns(`value`: Output<List<String>>) {
        this.frameworkArns = value
    }

    @JvmName("sffhrjtylebjvxre")
    public suspend fun frameworkArns(vararg values: Output<String>) {
        this.frameworkArns = Output.all(values.asList())
    }

    /**
     * @param values Specifies the Amazon Resource Names (ARNs) of the frameworks a report covers.
     */
    @JvmName("ksidbtxynkhjlcjm")
    public suspend fun frameworkArns(values: List<Output<String>>) {
        this.frameworkArns = Output.all(values)
    }

    /**
     * @param value Specifies the number of frameworks a report covers.
     */
    @JvmName("ysevxxlvjancnuem")
    public suspend fun numberOfFrameworks(`value`: Output<Int>) {
        this.numberOfFrameworks = value
    }

    /**
     * @param value Specifies the list of Organizational Units a report covers.
     */
    @JvmName("jilwrongkjrcgaui")
    public suspend fun organizationUnits(`value`: Output<List<String>>) {
        this.organizationUnits = value
    }

    @JvmName("djnrifwvxkicoxjd")
    public suspend fun organizationUnits(vararg values: Output<String>) {
        this.organizationUnits = Output.all(values.asList())
    }

    /**
     * @param values Specifies the list of Organizational Units a report covers.
     */
    @JvmName("lxixnmgscuqhwesi")
    public suspend fun organizationUnits(values: List<Output<String>>) {
        this.organizationUnits = Output.all(values)
    }

    /**
     * @param value Specifies the list of regions a report covers.
     */
    @JvmName("psqtviljnhflflny")
    public suspend fun regions(`value`: Output<List<String>>) {
        this.regions = value
    }

    @JvmName("vwjdnoacyyswxiqa")
    public suspend fun regions(vararg values: Output<String>) {
        this.regions = Output.all(values.asList())
    }

    /**
     * @param values Specifies the list of regions a report covers.
     */
    @JvmName("vcsnrlplabotxnsp")
    public suspend fun regions(values: List<Output<String>>) {
        this.regions = Output.all(values)
    }

    /**
     * @param value Identifies the report template for the report. Reports are built using a report template. The report templates are: `RESOURCE_COMPLIANCE_REPORT` | `CONTROL_COMPLIANCE_REPORT` | `BACKUP_JOB_REPORT` | `COPY_JOB_REPORT` | `RESTORE_JOB_REPORT`.
     */
    @JvmName("pacdewxvqaxfdebt")
    public suspend fun reportTemplate(`value`: Output<String>) {
        this.reportTemplate = value
    }

    /**
     * @param value Specifies the list of accounts a report covers.
     */
    @JvmName("qdhihbhnkfeabygk")
    public suspend fun accounts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accounts = mapped
    }

    /**
     * @param values Specifies the list of accounts a report covers.
     */
    @JvmName("pwdxpbdtljrsbkws")
    public suspend fun accounts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accounts = mapped
    }

    /**
     * @param value Specifies the Amazon Resource Names (ARNs) of the frameworks a report covers.
     */
    @JvmName("iddpavibhubgavfe")
    public suspend fun frameworkArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frameworkArns = mapped
    }

    /**
     * @param values Specifies the Amazon Resource Names (ARNs) of the frameworks a report covers.
     */
    @JvmName("whtwrboefpolqvsi")
    public suspend fun frameworkArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frameworkArns = mapped
    }

    /**
     * @param value Specifies the number of frameworks a report covers.
     */
    @JvmName("qcsgorwfuoqmiayd")
    public suspend fun numberOfFrameworks(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfFrameworks = mapped
    }

    /**
     * @param value Specifies the list of Organizational Units a report covers.
     */
    @JvmName("ykyonigpxmemkucj")
    public suspend fun organizationUnits(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationUnits = mapped
    }

    /**
     * @param values Specifies the list of Organizational Units a report covers.
     */
    @JvmName("yqcatsblxxdjoogw")
    public suspend fun organizationUnits(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.organizationUnits = mapped
    }

    /**
     * @param value Specifies the list of regions a report covers.
     */
    @JvmName("xpavjvpgupmdwitb")
    public suspend fun regions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    /**
     * @param values Specifies the list of regions a report covers.
     */
    @JvmName("ujekgcuqqsbwoutl")
    public suspend fun regions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    /**
     * @param value Identifies the report template for the report. Reports are built using a report template. The report templates are: `RESOURCE_COMPLIANCE_REPORT` | `CONTROL_COMPLIANCE_REPORT` | `BACKUP_JOB_REPORT` | `COPY_JOB_REPORT` | `RESTORE_JOB_REPORT`.
     */
    @JvmName("kwmettcxkwixpkmf")
    public suspend fun reportTemplate(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.reportTemplate = mapped
    }

    internal fun build(): ReportPlanReportSettingArgs = ReportPlanReportSettingArgs(
        accounts = accounts,
        frameworkArns = frameworkArns,
        numberOfFrameworks = numberOfFrameworks,
        organizationUnits = organizationUnits,
        regions = regions,
        reportTemplate = reportTemplate ?: throw PulumiNullFieldException("reportTemplate"),
    )
}
