@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.inputs

import com.pulumi.aws.backup.inputs.SelectionConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property stringEquals
 * @property stringLikes
 * @property stringNotEquals
 * @property stringNotLikes
 */
public data class SelectionConditionArgs(
    public val stringEquals: Output<List<SelectionConditionStringEqualArgs>>? = null,
    public val stringLikes: Output<List<SelectionConditionStringLikeArgs>>? = null,
    public val stringNotEquals: Output<List<SelectionConditionStringNotEqualArgs>>? = null,
    public val stringNotLikes: Output<List<SelectionConditionStringNotLikeArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.backup.inputs.SelectionConditionArgs> {
    override fun toJava(): com.pulumi.aws.backup.inputs.SelectionConditionArgs =
        com.pulumi.aws.backup.inputs.SelectionConditionArgs.builder()
            .stringEquals(
                stringEquals?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .stringLikes(
                stringLikes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .stringNotEquals(
                stringNotEquals?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .stringNotLikes(
                stringNotLikes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SelectionConditionArgs].
 */
@PulumiTagMarker
public class SelectionConditionArgsBuilder internal constructor() {
    private var stringEquals: Output<List<SelectionConditionStringEqualArgs>>? = null

    private var stringLikes: Output<List<SelectionConditionStringLikeArgs>>? = null

    private var stringNotEquals: Output<List<SelectionConditionStringNotEqualArgs>>? = null

    private var stringNotLikes: Output<List<SelectionConditionStringNotLikeArgs>>? = null

    /**
     * @param value
     */
    @JvmName("xgkgjnitqvvlehtn")
    public suspend fun stringEquals(`value`: Output<List<SelectionConditionStringEqualArgs>>) {
        this.stringEquals = value
    }

    @JvmName("cwcabcobmvqhpllj")
    public suspend fun stringEquals(vararg values: Output<SelectionConditionStringEqualArgs>) {
        this.stringEquals = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ypsmeumtigqcqjmn")
    public suspend fun stringEquals(values: List<Output<SelectionConditionStringEqualArgs>>) {
        this.stringEquals = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("fgygmqdbgyhqrwfb")
    public suspend fun stringLikes(`value`: Output<List<SelectionConditionStringLikeArgs>>) {
        this.stringLikes = value
    }

    @JvmName("dykpeqrpawfmeyvk")
    public suspend fun stringLikes(vararg values: Output<SelectionConditionStringLikeArgs>) {
        this.stringLikes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("yasrydpevijniuhc")
    public suspend fun stringLikes(values: List<Output<SelectionConditionStringLikeArgs>>) {
        this.stringLikes = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("bvnaciohfpkjqmgc")
    public suspend fun stringNotEquals(`value`: Output<List<SelectionConditionStringNotEqualArgs>>) {
        this.stringNotEquals = value
    }

    @JvmName("xwhxntbsbeytycug")
    public suspend fun stringNotEquals(vararg values: Output<SelectionConditionStringNotEqualArgs>) {
        this.stringNotEquals = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("uunlyirjdyuibsjy")
    public suspend fun stringNotEquals(values: List<Output<SelectionConditionStringNotEqualArgs>>) {
        this.stringNotEquals = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("lwacxrbjlexovgld")
    public suspend fun stringNotLikes(`value`: Output<List<SelectionConditionStringNotLikeArgs>>) {
        this.stringNotLikes = value
    }

    @JvmName("vghootspcwamgtfi")
    public suspend fun stringNotLikes(vararg values: Output<SelectionConditionStringNotLikeArgs>) {
        this.stringNotLikes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("rnpoudsfclnpqgqc")
    public suspend fun stringNotLikes(values: List<Output<SelectionConditionStringNotLikeArgs>>) {
        this.stringNotLikes = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("hepgrnrnkqyvusep")
    public suspend fun stringEquals(`value`: List<SelectionConditionStringEqualArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stringEquals = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mcmcthvteoqdpfet")
    public suspend
    fun stringEquals(argument: List<suspend SelectionConditionStringEqualArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SelectionConditionStringEqualArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.stringEquals = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xcwnqwvmixbsjiai")
    public suspend fun stringEquals(
        vararg
        argument: suspend SelectionConditionStringEqualArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SelectionConditionStringEqualArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.stringEquals = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bfdydjlkelvmfxir")
    public suspend
    fun stringEquals(argument: suspend SelectionConditionStringEqualArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SelectionConditionStringEqualArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.stringEquals = mapped
    }

    /**
     * @param values
     */
    @JvmName("lsnvtdujcdtkacql")
    public suspend fun stringEquals(vararg values: SelectionConditionStringEqualArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stringEquals = mapped
    }

    /**
     * @param value
     */
    @JvmName("snjognpgdpnojnqh")
    public suspend fun stringLikes(`value`: List<SelectionConditionStringLikeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stringLikes = mapped
    }

    /**
     * @param argument
     */
    @JvmName("axdkgydvuhlujpwm")
    public suspend
    fun stringLikes(argument: List<suspend SelectionConditionStringLikeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SelectionConditionStringLikeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.stringLikes = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dwhrtvnwigoowcbb")
    public suspend fun stringLikes(
        vararg
        argument: suspend SelectionConditionStringLikeArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SelectionConditionStringLikeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.stringLikes = mapped
    }

    /**
     * @param argument
     */
    @JvmName("pxbaltvkciqldfxf")
    public suspend
    fun stringLikes(argument: suspend SelectionConditionStringLikeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SelectionConditionStringLikeArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.stringLikes = mapped
    }

    /**
     * @param values
     */
    @JvmName("pwvvarulslnbqfbd")
    public suspend fun stringLikes(vararg values: SelectionConditionStringLikeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stringLikes = mapped
    }

    /**
     * @param value
     */
    @JvmName("ctkxkwjtmiopkkdo")
    public suspend fun stringNotEquals(`value`: List<SelectionConditionStringNotEqualArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stringNotEquals = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ysqeontnqmmllitg")
    public suspend
    fun stringNotEquals(argument: List<suspend SelectionConditionStringNotEqualArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SelectionConditionStringNotEqualArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.stringNotEquals = mapped
    }

    /**
     * @param argument
     */
    @JvmName("iwkvygvjymrqpilu")
    public suspend fun stringNotEquals(
        vararg
        argument: suspend SelectionConditionStringNotEqualArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SelectionConditionStringNotEqualArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.stringNotEquals = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rivnxgjkiihfgnyq")
    public suspend
    fun stringNotEquals(argument: suspend SelectionConditionStringNotEqualArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SelectionConditionStringNotEqualArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.stringNotEquals = mapped
    }

    /**
     * @param values
     */
    @JvmName("lxnisqcragodxtyp")
    public suspend fun stringNotEquals(vararg values: SelectionConditionStringNotEqualArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stringNotEquals = mapped
    }

    /**
     * @param value
     */
    @JvmName("tnykpogvjkfxmnnh")
    public suspend fun stringNotLikes(`value`: List<SelectionConditionStringNotLikeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stringNotLikes = mapped
    }

    /**
     * @param argument
     */
    @JvmName("oneocqqqmbifjiph")
    public suspend
    fun stringNotLikes(argument: List<suspend SelectionConditionStringNotLikeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SelectionConditionStringNotLikeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.stringNotLikes = mapped
    }

    /**
     * @param argument
     */
    @JvmName("tvmurwlpyooesdon")
    public suspend fun stringNotLikes(
        vararg
        argument: suspend SelectionConditionStringNotLikeArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SelectionConditionStringNotLikeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.stringNotLikes = mapped
    }

    /**
     * @param argument
     */
    @JvmName("pujqouofnfferpik")
    public suspend
    fun stringNotLikes(argument: suspend SelectionConditionStringNotLikeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SelectionConditionStringNotLikeArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.stringNotLikes = mapped
    }

    /**
     * @param values
     */
    @JvmName("lamwliyvkwclpryi")
    public suspend fun stringNotLikes(vararg values: SelectionConditionStringNotLikeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stringNotLikes = mapped
    }

    internal fun build(): SelectionConditionArgs = SelectionConditionArgs(
        stringEquals = stringEquals,
        stringLikes = stringLikes,
        stringNotEquals = stringNotEquals,
        stringNotLikes = stringNotLikes,
    )
}
