@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.inputs

import com.pulumi.aws.backup.inputs.SelectionConditionStringNotLikeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key The key in a key-value pair.
 * @property value The value in a key-value pair.
 */
public data class SelectionConditionStringNotLikeArgs(
    public val key: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.backup.inputs.SelectionConditionStringNotLikeArgs> {
    override fun toJava(): com.pulumi.aws.backup.inputs.SelectionConditionStringNotLikeArgs =
        com.pulumi.aws.backup.inputs.SelectionConditionStringNotLikeArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SelectionConditionStringNotLikeArgs].
 */
@PulumiTagMarker
public class SelectionConditionStringNotLikeArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The key in a key-value pair.
     */
    @JvmName("oyhfyjsboiibtdyl")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The value in a key-value pair.
     */
    @JvmName("fgvfkdkrfephrbtc")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The key in a key-value pair.
     */
    @JvmName("cwkjmoeoanhetjdj")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The value in a key-value pair.
     */
    @JvmName("oxffjmlufiyvyhoo")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): SelectionConditionStringNotLikeArgs = SelectionConditionStringNotLikeArgs(
        key = key ?: throw PulumiNullFieldException("key"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
