@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.inputs

import com.pulumi.aws.backup.inputs.SelectionSelectionTagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key The key in a key-value pair.
 * @property type An operation, such as `StringEquals`, that is applied to a key-value pair used to filter resources in a selection.
 * @property value The value in a key-value pair.
 */
public data class SelectionSelectionTagArgs(
    public val key: Output<String>,
    public val type: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.backup.inputs.SelectionSelectionTagArgs> {
    override fun toJava(): com.pulumi.aws.backup.inputs.SelectionSelectionTagArgs =
        com.pulumi.aws.backup.inputs.SelectionSelectionTagArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SelectionSelectionTagArgs].
 */
@PulumiTagMarker
public class SelectionSelectionTagArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var type: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The key in a key-value pair.
     */
    @JvmName("ggvyexgenoisphnq")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value An operation, such as `StringEquals`, that is applied to a key-value pair used to filter resources in a selection.
     */
    @JvmName("kvkfmyafxekyvqog")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The value in a key-value pair.
     */
    @JvmName("gknwcuyfloxnfhte")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The key in a key-value pair.
     */
    @JvmName("egsjgujrmmbftvku")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value An operation, such as `StringEquals`, that is applied to a key-value pair used to filter resources in a selection.
     */
    @JvmName("vawvfaheomuhtknb")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The value in a key-value pair.
     */
    @JvmName("fyoprjflknyhrknb")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): SelectionSelectionTagArgs = SelectionSelectionTagArgs(
        key = key ?: throw PulumiNullFieldException("key"),
        type = type ?: throw PulumiNullFieldException("type"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
