@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getPlan.
 * @property arn ARN of the backup plan.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name Display name of a backup plan.
 * @property planId
 * @property tags Metadata that you can assign to help organize the plans you create.
 * @property version Unique, randomly generated, Unicode, UTF-8 encoded string that serves as the version ID of the backup plan.
 */
public data class GetPlanResult(
    public val arn: String,
    public val id: String,
    public val name: String,
    public val planId: String,
    public val tags: Map<String, String>,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.backup.outputs.GetPlanResult): GetPlanResult =
            GetPlanResult(
                arn = javaType.arn(),
                id = javaType.id(),
                name = javaType.name(),
                planId = javaType.planId(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                version = javaType.version(),
            )
    }
}
