@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property accounts (Optional) Specifies the list of accounts a report covers.
 * @property frameworkArns ARNs of the frameworks a report covers.
 * @property numberOfFrameworks Specifies the number of frameworks a report covers.
 * @property organizationUnits (Optional) Specifies the list of Organizational Units a report covers.
 * @property regions (Optional) Specifies the list of regions a report covers.
 * @property reportTemplate Identifies the report template for the report. Reports are built using a report template.
 */
public data class GetReportPlanReportSetting(
    public val accounts: List<String>,
    public val frameworkArns: List<String>,
    public val numberOfFrameworks: Int,
    public val organizationUnits: List<String>,
    public val regions: List<String>,
    public val reportTemplate: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.backup.outputs.GetReportPlanReportSetting):
            GetReportPlanReportSetting = GetReportPlanReportSetting(
            accounts = javaType.accounts().map({ args0 -> args0 }),
            frameworkArns = javaType.frameworkArns().map({ args0 -> args0 }),
            numberOfFrameworks = javaType.numberOfFrameworks(),
            organizationUnits = javaType.organizationUnits().map({ args0 -> args0 }),
            regions = javaType.regions().map({ args0 -> args0 }),
            reportTemplate = javaType.reportTemplate(),
        )
    }
}
