@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property coldStorageAfter Specifies the number of days after creation that a recovery point is moved to cold storage.
 * @property deleteAfter Specifies the number of days after creation that a recovery point is deleted. Must be 90 days greater than `cold_storage_after`.
 */
public data class PlanRuleCopyActionLifecycle(
    public val coldStorageAfter: Int? = null,
    public val deleteAfter: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.backup.outputs.PlanRuleCopyActionLifecycle):
            PlanRuleCopyActionLifecycle = PlanRuleCopyActionLifecycle(
            coldStorageAfter = javaType.coldStorageAfter().map({ args0 -> args0 }).orElse(null),
            deleteAfter = javaType.deleteAfter().map({ args0 -> args0 }).orElse(null),
        )
    }
}
