@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property formats A list of the format of your reports: CSV, JSON, or both. If not specified, the default format is CSV.
 * @property s3BucketName The unique name of the S3 bucket that receives your reports.
 * @property s3KeyPrefix The prefix for where Backup Audit Manager delivers your reports to Amazon S3. The prefix is this part of the following path: s3://your-bucket-name/prefix/Backup/us-west-2/year/month/day/report-name. If not specified, there is no prefix.
 */
public data class ReportPlanReportDeliveryChannel(
    public val formats: List<String>? = null,
    public val s3BucketName: String,
    public val s3KeyPrefix: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.backup.outputs.ReportPlanReportDeliveryChannel):
            ReportPlanReportDeliveryChannel = ReportPlanReportDeliveryChannel(
            formats = javaType.formats().map({ args0 -> args0 }),
            s3BucketName = javaType.s3BucketName(),
            s3KeyPrefix = javaType.s3KeyPrefix().map({ args0 -> args0 }).orElse(null),
        )
    }
}
