@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.backup.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property accounts Specifies the list of accounts a report covers.
 * @property frameworkArns Specifies the Amazon Resource Names (ARNs) of the frameworks a report covers.
 * @property numberOfFrameworks Specifies the number of frameworks a report covers.
 * @property organizationUnits Specifies the list of Organizational Units a report covers.
 * @property regions Specifies the list of regions a report covers.
 * @property reportTemplate Identifies the report template for the report. Reports are built using a report template. The report templates are: `RESOURCE_COMPLIANCE_REPORT` | `CONTROL_COMPLIANCE_REPORT` | `BACKUP_JOB_REPORT` | `COPY_JOB_REPORT` | `RESTORE_JOB_REPORT`.
 */
public data class ReportPlanReportSetting(
    public val accounts: List<String>? = null,
    public val frameworkArns: List<String>? = null,
    public val numberOfFrameworks: Int? = null,
    public val organizationUnits: List<String>? = null,
    public val regions: List<String>? = null,
    public val reportTemplate: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.backup.outputs.ReportPlanReportSetting):
            ReportPlanReportSetting = ReportPlanReportSetting(
            accounts = javaType.accounts().map({ args0 -> args0 }),
            frameworkArns = javaType.frameworkArns().map({ args0 -> args0 }),
            numberOfFrameworks = javaType.numberOfFrameworks().map({ args0 -> args0 }).orElse(null),
            organizationUnits = javaType.organizationUnits().map({ args0 -> args0 }),
            regions = javaType.regions().map({ args0 -> args0 }),
            reportTemplate = javaType.reportTemplate(),
        )
    }
}
