@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin

import com.pulumi.aws.batch.BatchFunctions.getComputeEnvironmentPlain
import com.pulumi.aws.batch.BatchFunctions.getJobQueuePlain
import com.pulumi.aws.batch.BatchFunctions.getSchedulingPolicyPlain
import com.pulumi.aws.batch.kotlin.inputs.GetComputeEnvironmentPlainArgs
import com.pulumi.aws.batch.kotlin.inputs.GetComputeEnvironmentPlainArgsBuilder
import com.pulumi.aws.batch.kotlin.inputs.GetJobQueuePlainArgs
import com.pulumi.aws.batch.kotlin.inputs.GetJobQueuePlainArgsBuilder
import com.pulumi.aws.batch.kotlin.inputs.GetSchedulingPolicyPlainArgs
import com.pulumi.aws.batch.kotlin.inputs.GetSchedulingPolicyPlainArgsBuilder
import com.pulumi.aws.batch.kotlin.outputs.GetComputeEnvironmentResult
import com.pulumi.aws.batch.kotlin.outputs.GetJobQueueResult
import com.pulumi.aws.batch.kotlin.outputs.GetSchedulingPolicyResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.batch.kotlin.outputs.GetComputeEnvironmentResult.Companion.toKotlin as getComputeEnvironmentResultToKotlin
import com.pulumi.aws.batch.kotlin.outputs.GetJobQueueResult.Companion.toKotlin as getJobQueueResultToKotlin
import com.pulumi.aws.batch.kotlin.outputs.GetSchedulingPolicyResult.Companion.toKotlin as getSchedulingPolicyResultToKotlin

public object BatchFunctions {
    /**
     * The Batch Compute Environment data source allows access to details of a specific
     * compute environment within AWS Batch.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.batch.BatchFunctions;
     * import com.pulumi.aws.batch.inputs.GetComputeEnvironmentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var batch-mongo = BatchFunctions.getComputeEnvironment(GetComputeEnvironmentArgs.builder()
     *             .computeEnvironmentName("batch-mongo-production")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getComputeEnvironment.
     * @return A collection of values returned by getComputeEnvironment.
     */
    public suspend fun getComputeEnvironment(argument: GetComputeEnvironmentPlainArgs):
        GetComputeEnvironmentResult =
        getComputeEnvironmentResultToKotlin(getComputeEnvironmentPlain(argument.toJava()).await())

    /**
     * @see [getComputeEnvironment].
     * @param computeEnvironmentName Name of the Batch Compute Environment
     * @param tags Key-value map of resource tags
     * @return A collection of values returned by getComputeEnvironment.
     */
    public suspend fun getComputeEnvironment(
        computeEnvironmentName: String,
        tags: Map<String, String>? = null,
    ): GetComputeEnvironmentResult {
        val argument = GetComputeEnvironmentPlainArgs(
            computeEnvironmentName = computeEnvironmentName,
            tags = tags,
        )
        return getComputeEnvironmentResultToKotlin(getComputeEnvironmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getComputeEnvironment].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;batch&#46;kotlin&#46;inputs&#46;GetComputeEnvironmentPlainArgs].
     * @return A collection of values returned by getComputeEnvironment.
     */
    public suspend
    fun getComputeEnvironment(argument: suspend GetComputeEnvironmentPlainArgsBuilder.() -> Unit):
        GetComputeEnvironmentResult {
        val builder = GetComputeEnvironmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getComputeEnvironmentResultToKotlin(getComputeEnvironmentPlain(builtArgument.toJava()).await())
    }

    /**
     * The Batch Job Queue data source allows access to details of a specific
     * job queue within AWS Batch.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.batch.BatchFunctions;
     * import com.pulumi.aws.batch.inputs.GetJobQueueArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test-queue = BatchFunctions.getJobQueue(GetJobQueueArgs.builder()
     *             .name("tf-test-batch-job-queue")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getJobQueue.
     * @return A collection of values returned by getJobQueue.
     */
    public suspend fun getJobQueue(argument: GetJobQueuePlainArgs): GetJobQueueResult =
        getJobQueueResultToKotlin(getJobQueuePlain(argument.toJava()).await())

    /**
     * @see [getJobQueue].
     * @param name Name of the job queue.
     * @param tags Key-value map of resource tags
     * @return A collection of values returned by getJobQueue.
     */
    public suspend fun getJobQueue(name: String, tags: Map<String, String>? = null):
        GetJobQueueResult {
        val argument = GetJobQueuePlainArgs(
            name = name,
            tags = tags,
        )
        return getJobQueueResultToKotlin(getJobQueuePlain(argument.toJava()).await())
    }

    /**
     * @see [getJobQueue].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;batch&#46;kotlin&#46;inputs&#46;GetJobQueuePlainArgs].
     * @return A collection of values returned by getJobQueue.
     */
    public suspend fun getJobQueue(argument: suspend GetJobQueuePlainArgsBuilder.() -> Unit):
        GetJobQueueResult {
        val builder = GetJobQueuePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getJobQueueResultToKotlin(getJobQueuePlain(builtArgument.toJava()).await())
    }

    /**
     * The Batch Scheduling Policy data source allows access to details of a specific Scheduling Policy within AWS Batch.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.batch.BatchFunctions;
     * import com.pulumi.aws.batch.inputs.GetSchedulingPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = BatchFunctions.getSchedulingPolicy(GetSchedulingPolicyArgs.builder()
     *             .arn("arn:aws:batch:us-east-1:012345678910:scheduling-policy/example")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getSchedulingPolicy.
     * @return A collection of values returned by getSchedulingPolicy.
     */
    public suspend fun getSchedulingPolicy(argument: GetSchedulingPolicyPlainArgs):
        GetSchedulingPolicyResult =
        getSchedulingPolicyResultToKotlin(getSchedulingPolicyPlain(argument.toJava()).await())

    /**
     * @see [getSchedulingPolicy].
     * @param arn ARN of the scheduling policy.
     * @param tags Key-value map of resource tags
     * @return A collection of values returned by getSchedulingPolicy.
     */
    public suspend fun getSchedulingPolicy(arn: String, tags: Map<String, String>? = null):
        GetSchedulingPolicyResult {
        val argument = GetSchedulingPolicyPlainArgs(
            arn = arn,
            tags = tags,
        )
        return getSchedulingPolicyResultToKotlin(getSchedulingPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getSchedulingPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;batch&#46;kotlin&#46;inputs&#46;GetSchedulingPolicyPlainArgs].
     * @return A collection of values returned by getSchedulingPolicy.
     */
    public suspend
    fun getSchedulingPolicy(argument: suspend GetSchedulingPolicyPlainArgsBuilder.() -> Unit):
        GetSchedulingPolicyResult {
        val builder = GetSchedulingPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSchedulingPolicyResultToKotlin(getSchedulingPolicyPlain(builtArgument.toJava()).await())
    }
}
