@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin

import com.pulumi.aws.batch.kotlin.outputs.ComputeEnvironmentComputeResources
import com.pulumi.aws.batch.kotlin.outputs.ComputeEnvironmentEksConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.batch.kotlin.outputs.ComputeEnvironmentComputeResources.Companion.toKotlin as computeEnvironmentComputeResourcesToKotlin
import com.pulumi.aws.batch.kotlin.outputs.ComputeEnvironmentEksConfiguration.Companion.toKotlin as computeEnvironmentEksConfigurationToKotlin

/**
 * Builder for [ComputeEnvironment].
 */
@PulumiTagMarker
public class ComputeEnvironmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ComputeEnvironmentArgs = ComputeEnvironmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ComputeEnvironmentArgsBuilder.() -> Unit) {
        val builder = ComputeEnvironmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ComputeEnvironment {
        val builtJavaResource = com.pulumi.aws.batch.ComputeEnvironment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ComputeEnvironment(builtJavaResource)
    }
}

/**
 * Creates a AWS Batch compute environment. Compute environments contain the Amazon ECS container instances that are used to run containerized batch jobs.
 * For information about AWS Batch, see [What is AWS Batch?](http://docs.aws.amazon.com/batch/latest/userguide/what-is-batch.html) .
 * For information about compute environment, see [Compute Environments](http://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html) .
 * > **Note:** To prevent a race condition during environment deletion, make sure to set `depends_on` to the related `aws.iam.RolePolicyAttachment`;
 * otherwise, the policy may be destroyed too soon and the compute environment will then get stuck in the `DELETING` state, see [Troubleshooting AWS Batch](http://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html) .
 * ## Example Usage
 * ### EC2 Type
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.iam.InstanceProfile;
 * import com.pulumi.aws.iam.InstanceProfileArgs;
 * import com.pulumi.aws.ec2.SecurityGroup;
 * import com.pulumi.aws.ec2.SecurityGroupArgs;
 * import com.pulumi.aws.ec2.inputs.SecurityGroupEgressArgs;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.ec2.PlacementGroup;
 * import com.pulumi.aws.ec2.PlacementGroupArgs;
 * import com.pulumi.aws.batch.ComputeEnvironment;
 * import com.pulumi.aws.batch.ComputeEnvironmentArgs;
 * import com.pulumi.aws.batch.inputs.ComputeEnvironmentComputeResourcesArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var ec2AssumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("ec2.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var ecsInstanceRoleRole = new Role("ecsInstanceRoleRole", RoleArgs.builder()
 *             .assumeRolePolicy(ec2AssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var ecsInstanceRoleRolePolicyAttachment = new RolePolicyAttachment("ecsInstanceRoleRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .role(ecsInstanceRoleRole.name())
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AmazonEC2ContainerServiceforEC2Role")
 *             .build());
 *         var ecsInstanceRoleInstanceProfile = new InstanceProfile("ecsInstanceRoleInstanceProfile", InstanceProfileArgs.builder()
 *             .role(ecsInstanceRoleRole.name())
 *             .build());
 *         final var batchAssumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("batch.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var awsBatchServiceRoleRole = new Role("awsBatchServiceRoleRole", RoleArgs.builder()
 *             .assumeRolePolicy(batchAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var awsBatchServiceRoleRolePolicyAttachment = new RolePolicyAttachment("awsBatchServiceRoleRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .role(awsBatchServiceRoleRole.name())
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AWSBatchServiceRole")
 *             .build());
 *         var sampleSecurityGroup = new SecurityGroup("sampleSecurityGroup", SecurityGroupArgs.builder()
 *             .egress(SecurityGroupEgressArgs.builder()
 *                 .fromPort(0)
 *                 .toPort(0)
 *                 .protocol("-1")
 *                 .cidrBlocks("0.0.0.0/0")
 *                 .build())
 *             .build());
 *         var sampleVpc = new Vpc("sampleVpc", VpcArgs.builder()
 *             .cidrBlock("10.1.0.0/16")
 *             .build());
 *         var sampleSubnet = new Subnet("sampleSubnet", SubnetArgs.builder()
 *             .vpcId(sampleVpc.id())
 *             .cidrBlock("10.1.1.0/24")
 *             .build());
 *         var samplePlacementGroup = new PlacementGroup("samplePlacementGroup", PlacementGroupArgs.builder()
 *             .strategy("cluster")
 *             .build());
 *         var sampleComputeEnvironment = new ComputeEnvironment("sampleComputeEnvironment", ComputeEnvironmentArgs.builder()
 *             .computeEnvironmentName("sample")
 *             .computeResources(ComputeEnvironmentComputeResourcesArgs.builder()
 *                 .instanceRole(ecsInstanceRoleInstanceProfile.arn())
 *                 .instanceTypes("c4.large")
 *                 .maxVcpus(16)
 *                 .minVcpus(0)
 *                 .placementGroup(samplePlacementGroup.name())
 *                 .securityGroupIds(sampleSecurityGroup.id())
 *                 .subnets(sampleSubnet.id())
 *                 .type("EC2")
 *                 .build())
 *             .serviceRole(awsBatchServiceRoleRole.arn())
 *             .type("MANAGED")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(awsBatchServiceRoleRolePolicyAttachment)
 *                 .build());
 *     }
 * }
 * ```
 * ### Fargate Type
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.batch.ComputeEnvironment;
 * import com.pulumi.aws.batch.ComputeEnvironmentArgs;
 * import com.pulumi.aws.batch.inputs.ComputeEnvironmentComputeResourcesArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sample = new ComputeEnvironment("sample", ComputeEnvironmentArgs.builder()
 *             .computeEnvironmentName("sample")
 *             .computeResources(ComputeEnvironmentComputeResourcesArgs.builder()
 *                 .maxVcpus(16)
 *                 .securityGroupIds(aws_security_group.sample().id())
 *                 .subnets(aws_subnet.sample().id())
 *                 .type("FARGATE")
 *                 .build())
 *             .serviceRole(aws_iam_role.aws_batch_service_role().arn())
 *             .type("MANAGED")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_iam_role_policy_attachment.aws_batch_service_role())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AWS Batch compute using the `compute_environment_name`. For example:
 * ```sh
 *  $ pulumi import aws:batch/computeEnvironment:ComputeEnvironment sample sample
 * ```
 *
 */
public class ComputeEnvironment internal constructor(
    override val javaResource: com.pulumi.aws.batch.ComputeEnvironment,
) : KotlinCustomResource(javaResource, ComputeEnvironmentMapper) {
    /**
     * The Amazon Resource Name (ARN) of the compute environment.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name for your compute environment. Up to 128 letters (uppercase and lowercase), numbers, and underscores are allowed. If omitted, the provider will assign a random, unique name.
     */
    public val computeEnvironmentName: Output<String>
        get() = javaResource.computeEnvironmentName().applyValue({ args0 -> args0 })

    /**
     * Creates a unique compute environment name beginning with the specified prefix. Conflicts with `compute_environment_name`.
     */
    public val computeEnvironmentNamePrefix: Output<String>
        get() = javaResource.computeEnvironmentNamePrefix().applyValue({ args0 -> args0 })

    /**
     * Details of the compute resources managed by the compute environment. This parameter is required for managed compute environments. See details below.
     */
    public val computeResources: Output<ComputeEnvironmentComputeResources>?
        get() = javaResource.computeResources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> computeEnvironmentComputeResourcesToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The Amazon Resource Name (ARN) of the underlying Amazon ECS cluster used by the compute environment.
     */
    public val ecsClusterArn: Output<String>
        get() = javaResource.ecsClusterArn().applyValue({ args0 -> args0 })

    /**
     * Details for the Amazon EKS cluster that supports the compute environment. See details below.
     */
    public val eksConfiguration: Output<ComputeEnvironmentEksConfiguration>?
        get() = javaResource.eksConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> computeEnvironmentEksConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to other AWS services on your behalf.
     */
    public val serviceRole: Output<String>
        get() = javaResource.serviceRole().applyValue({ args0 -> args0 })

    /**
     * The state of the compute environment. If the state is `ENABLED`, then the compute environment accepts jobs from a queue and can scale out automatically based on queues. Valid items are `ENABLED` or `DISABLED`. Defaults to `ENABLED`.
     */
    public val state: Output<String>?
        get() = javaResource.state().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The current status of the compute environment (for example, CREATING or VALID).
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A short, human-readable string to provide additional details about the current status of the compute environment.
     */
    public val statusReason: Output<String>
        get() = javaResource.statusReason().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The type of the compute environment. Valid items are `MANAGED` or `UNMANAGED`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ComputeEnvironmentMapper : ResourceMapper<ComputeEnvironment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.batch.ComputeEnvironment::class == javaResource::class

    override fun map(javaResource: Resource): ComputeEnvironment = ComputeEnvironment(
        javaResource as
            com.pulumi.aws.batch.ComputeEnvironment,
    )
}

/**
 * @see [ComputeEnvironment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ComputeEnvironment].
 */
public suspend fun computeEnvironment(
    name: String,
    block: suspend ComputeEnvironmentResourceBuilder.() -> Unit,
): ComputeEnvironment {
    val builder = ComputeEnvironmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ComputeEnvironment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun computeEnvironment(name: String): ComputeEnvironment {
    val builder = ComputeEnvironmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
