@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin

import com.pulumi.aws.batch.ComputeEnvironmentArgs.builder
import com.pulumi.aws.batch.kotlin.inputs.ComputeEnvironmentComputeResourcesArgs
import com.pulumi.aws.batch.kotlin.inputs.ComputeEnvironmentComputeResourcesArgsBuilder
import com.pulumi.aws.batch.kotlin.inputs.ComputeEnvironmentEksConfigurationArgs
import com.pulumi.aws.batch.kotlin.inputs.ComputeEnvironmentEksConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates a AWS Batch compute environment. Compute environments contain the Amazon ECS container instances that are used to run containerized batch jobs.
 * For information about AWS Batch, see [What is AWS Batch?](http://docs.aws.amazon.com/batch/latest/userguide/what-is-batch.html) .
 * For information about compute environment, see [Compute Environments](http://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html) .
 * > **Note:** To prevent a race condition during environment deletion, make sure to set `depends_on` to the related `aws.iam.RolePolicyAttachment`;
 * otherwise, the policy may be destroyed too soon and the compute environment will then get stuck in the `DELETING` state, see [Troubleshooting AWS Batch](http://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html) .
 * ## Example Usage
 * ### EC2 Type
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.iam.InstanceProfile;
 * import com.pulumi.aws.iam.InstanceProfileArgs;
 * import com.pulumi.aws.ec2.SecurityGroup;
 * import com.pulumi.aws.ec2.SecurityGroupArgs;
 * import com.pulumi.aws.ec2.inputs.SecurityGroupEgressArgs;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.ec2.PlacementGroup;
 * import com.pulumi.aws.ec2.PlacementGroupArgs;
 * import com.pulumi.aws.batch.ComputeEnvironment;
 * import com.pulumi.aws.batch.ComputeEnvironmentArgs;
 * import com.pulumi.aws.batch.inputs.ComputeEnvironmentComputeResourcesArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var ec2AssumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("ec2.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var ecsInstanceRoleRole = new Role("ecsInstanceRoleRole", RoleArgs.builder()
 *             .assumeRolePolicy(ec2AssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var ecsInstanceRoleRolePolicyAttachment = new RolePolicyAttachment("ecsInstanceRoleRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .role(ecsInstanceRoleRole.name())
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AmazonEC2ContainerServiceforEC2Role")
 *             .build());
 *         var ecsInstanceRoleInstanceProfile = new InstanceProfile("ecsInstanceRoleInstanceProfile", InstanceProfileArgs.builder()
 *             .role(ecsInstanceRoleRole.name())
 *             .build());
 *         final var batchAssumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("batch.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var awsBatchServiceRoleRole = new Role("awsBatchServiceRoleRole", RoleArgs.builder()
 *             .assumeRolePolicy(batchAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var awsBatchServiceRoleRolePolicyAttachment = new RolePolicyAttachment("awsBatchServiceRoleRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .role(awsBatchServiceRoleRole.name())
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AWSBatchServiceRole")
 *             .build());
 *         var sampleSecurityGroup = new SecurityGroup("sampleSecurityGroup", SecurityGroupArgs.builder()
 *             .egress(SecurityGroupEgressArgs.builder()
 *                 .fromPort(0)
 *                 .toPort(0)
 *                 .protocol("-1")
 *                 .cidrBlocks("0.0.0.0/0")
 *                 .build())
 *             .build());
 *         var sampleVpc = new Vpc("sampleVpc", VpcArgs.builder()
 *             .cidrBlock("10.1.0.0/16")
 *             .build());
 *         var sampleSubnet = new Subnet("sampleSubnet", SubnetArgs.builder()
 *             .vpcId(sampleVpc.id())
 *             .cidrBlock("10.1.1.0/24")
 *             .build());
 *         var samplePlacementGroup = new PlacementGroup("samplePlacementGroup", PlacementGroupArgs.builder()
 *             .strategy("cluster")
 *             .build());
 *         var sampleComputeEnvironment = new ComputeEnvironment("sampleComputeEnvironment", ComputeEnvironmentArgs.builder()
 *             .computeEnvironmentName("sample")
 *             .computeResources(ComputeEnvironmentComputeResourcesArgs.builder()
 *                 .instanceRole(ecsInstanceRoleInstanceProfile.arn())
 *                 .instanceTypes("c4.large")
 *                 .maxVcpus(16)
 *                 .minVcpus(0)
 *                 .placementGroup(samplePlacementGroup.name())
 *                 .securityGroupIds(sampleSecurityGroup.id())
 *                 .subnets(sampleSubnet.id())
 *                 .type("EC2")
 *                 .build())
 *             .serviceRole(awsBatchServiceRoleRole.arn())
 *             .type("MANAGED")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(awsBatchServiceRoleRolePolicyAttachment)
 *                 .build());
 *     }
 * }
 * ```
 * ### Fargate Type
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.batch.ComputeEnvironment;
 * import com.pulumi.aws.batch.ComputeEnvironmentArgs;
 * import com.pulumi.aws.batch.inputs.ComputeEnvironmentComputeResourcesArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sample = new ComputeEnvironment("sample", ComputeEnvironmentArgs.builder()
 *             .computeEnvironmentName("sample")
 *             .computeResources(ComputeEnvironmentComputeResourcesArgs.builder()
 *                 .maxVcpus(16)
 *                 .securityGroupIds(aws_security_group.sample().id())
 *                 .subnets(aws_subnet.sample().id())
 *                 .type("FARGATE")
 *                 .build())
 *             .serviceRole(aws_iam_role.aws_batch_service_role().arn())
 *             .type("MANAGED")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_iam_role_policy_attachment.aws_batch_service_role())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AWS Batch compute using the `compute_environment_name`. For example:
 * ```sh
 *  $ pulumi import aws:batch/computeEnvironment:ComputeEnvironment sample sample
 * ```
 * @property computeEnvironmentName The name for your compute environment. Up to 128 letters (uppercase and lowercase), numbers, and underscores are allowed. If omitted, the provider will assign a random, unique name.
 * @property computeEnvironmentNamePrefix Creates a unique compute environment name beginning with the specified prefix. Conflicts with `compute_environment_name`.
 * @property computeResources Details of the compute resources managed by the compute environment. This parameter is required for managed compute environments. See details below.
 * @property eksConfiguration Details for the Amazon EKS cluster that supports the compute environment. See details below.
 * @property serviceRole The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to other AWS services on your behalf.
 * @property state The state of the compute environment. If the state is `ENABLED`, then the compute environment accepts jobs from a queue and can scale out automatically based on queues. Valid items are `ENABLED` or `DISABLED`. Defaults to `ENABLED`.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type The type of the compute environment. Valid items are `MANAGED` or `UNMANAGED`.
 */
public data class ComputeEnvironmentArgs(
    public val computeEnvironmentName: Output<String>? = null,
    public val computeEnvironmentNamePrefix: Output<String>? = null,
    public val computeResources: Output<ComputeEnvironmentComputeResourcesArgs>? = null,
    public val eksConfiguration: Output<ComputeEnvironmentEksConfigurationArgs>? = null,
    public val serviceRole: Output<String>? = null,
    public val state: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.batch.ComputeEnvironmentArgs> {
    override fun toJava(): com.pulumi.aws.batch.ComputeEnvironmentArgs =
        com.pulumi.aws.batch.ComputeEnvironmentArgs.builder()
            .computeEnvironmentName(computeEnvironmentName?.applyValue({ args0 -> args0 }))
            .computeEnvironmentNamePrefix(computeEnvironmentNamePrefix?.applyValue({ args0 -> args0 }))
            .computeResources(computeResources?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .eksConfiguration(eksConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .serviceRole(serviceRole?.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ComputeEnvironmentArgs].
 */
@PulumiTagMarker
public class ComputeEnvironmentArgsBuilder internal constructor() {
    private var computeEnvironmentName: Output<String>? = null

    private var computeEnvironmentNamePrefix: Output<String>? = null

    private var computeResources: Output<ComputeEnvironmentComputeResourcesArgs>? = null

    private var eksConfiguration: Output<ComputeEnvironmentEksConfigurationArgs>? = null

    private var serviceRole: Output<String>? = null

    private var state: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value The name for your compute environment. Up to 128 letters (uppercase and lowercase), numbers, and underscores are allowed. If omitted, the provider will assign a random, unique name.
     */
    @JvmName("nysmwxsbqsnniair")
    public suspend fun computeEnvironmentName(`value`: Output<String>) {
        this.computeEnvironmentName = value
    }

    /**
     * @param value Creates a unique compute environment name beginning with the specified prefix. Conflicts with `compute_environment_name`.
     */
    @JvmName("hnvpyyakuncvvuan")
    public suspend fun computeEnvironmentNamePrefix(`value`: Output<String>) {
        this.computeEnvironmentNamePrefix = value
    }

    /**
     * @param value Details of the compute resources managed by the compute environment. This parameter is required for managed compute environments. See details below.
     */
    @JvmName("flcamifolrjuwtxj")
    public suspend fun computeResources(`value`: Output<ComputeEnvironmentComputeResourcesArgs>) {
        this.computeResources = value
    }

    /**
     * @param value Details for the Amazon EKS cluster that supports the compute environment. See details below.
     */
    @JvmName("phtffvfdodsstold")
    public suspend fun eksConfiguration(`value`: Output<ComputeEnvironmentEksConfigurationArgs>) {
        this.eksConfiguration = value
    }

    /**
     * @param value The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to other AWS services on your behalf.
     */
    @JvmName("fxufoljxyetevrtc")
    public suspend fun serviceRole(`value`: Output<String>) {
        this.serviceRole = value
    }

    /**
     * @param value The state of the compute environment. If the state is `ENABLED`, then the compute environment accepts jobs from a queue and can scale out automatically based on queues. Valid items are `ENABLED` or `DISABLED`. Defaults to `ENABLED`.
     */
    @JvmName("jflfujumasxbsebx")
    public suspend fun state(`value`: Output<String>) {
        this.state = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ynqrypisxegmhmlg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The type of the compute environment. Valid items are `MANAGED` or `UNMANAGED`.
     */
    @JvmName("txoxwnxuvhulmore")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The name for your compute environment. Up to 128 letters (uppercase and lowercase), numbers, and underscores are allowed. If omitted, the provider will assign a random, unique name.
     */
    @JvmName("ggarhfhgmyuyffnn")
    public suspend fun computeEnvironmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeEnvironmentName = mapped
    }

    /**
     * @param value Creates a unique compute environment name beginning with the specified prefix. Conflicts with `compute_environment_name`.
     */
    @JvmName("sekmqvwvyodqklxr")
    public suspend fun computeEnvironmentNamePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeEnvironmentNamePrefix = mapped
    }

    /**
     * @param value Details of the compute resources managed by the compute environment. This parameter is required for managed compute environments. See details below.
     */
    @JvmName("navusjevbfqvwmrr")
    public suspend fun computeResources(`value`: ComputeEnvironmentComputeResourcesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeResources = mapped
    }

    /**
     * @param argument Details of the compute resources managed by the compute environment. This parameter is required for managed compute environments. See details below.
     */
    @JvmName("qnetwajvbyosvqju")
    public suspend
    fun computeResources(argument: suspend ComputeEnvironmentComputeResourcesArgsBuilder.() -> Unit) {
        val toBeMapped = ComputeEnvironmentComputeResourcesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.computeResources = mapped
    }

    /**
     * @param value Details for the Amazon EKS cluster that supports the compute environment. See details below.
     */
    @JvmName("jkmbjpinvoscbbme")
    public suspend fun eksConfiguration(`value`: ComputeEnvironmentEksConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eksConfiguration = mapped
    }

    /**
     * @param argument Details for the Amazon EKS cluster that supports the compute environment. See details below.
     */
    @JvmName("qfoitmsumolkohnq")
    public suspend
    fun eksConfiguration(argument: suspend ComputeEnvironmentEksConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ComputeEnvironmentEksConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.eksConfiguration = mapped
    }

    /**
     * @param value The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to other AWS services on your behalf.
     */
    @JvmName("ylspukqfiasjitur")
    public suspend fun serviceRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceRole = mapped
    }

    /**
     * @param value The state of the compute environment. If the state is `ENABLED`, then the compute environment accepts jobs from a queue and can scale out automatically based on queues. Valid items are `ENABLED` or `DISABLED`. Defaults to `ENABLED`.
     */
    @JvmName("habuexevalnxjqyh")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vhciltwyfctyytpp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xshrfycrnmcsrkyu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The type of the compute environment. Valid items are `MANAGED` or `UNMANAGED`.
     */
    @JvmName("nkmmipfwqtkfqtkq")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ComputeEnvironmentArgs = ComputeEnvironmentArgs(
        computeEnvironmentName = computeEnvironmentName,
        computeEnvironmentNamePrefix = computeEnvironmentNamePrefix,
        computeResources = computeResources,
        eksConfiguration = eksConfiguration,
        serviceRole = serviceRole,
        state = state,
        tags = tags,
        type = type,
    )
}
