@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin

import com.pulumi.aws.batch.kotlin.outputs.JobDefinitionRetryStrategy
import com.pulumi.aws.batch.kotlin.outputs.JobDefinitionTimeout
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.batch.kotlin.outputs.JobDefinitionRetryStrategy.Companion.toKotlin as jobDefinitionRetryStrategyToKotlin
import com.pulumi.aws.batch.kotlin.outputs.JobDefinitionTimeout.Companion.toKotlin as jobDefinitionTimeoutToKotlin

/**
 * Builder for [JobDefinition].
 */
@PulumiTagMarker
public class JobDefinitionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: JobDefinitionArgs = JobDefinitionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend JobDefinitionArgsBuilder.() -> Unit) {
        val builder = JobDefinitionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): JobDefinition {
        val builtJavaResource = com.pulumi.aws.batch.JobDefinition(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return JobDefinition(builtJavaResource)
    }
}

/**
 * Provides a Batch Job Definition resource.
 * ## Example Usage
 * ### Job definition of type container
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.batch.JobDefinition;
 * import com.pulumi.aws.batch.JobDefinitionArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new JobDefinition("test", JobDefinitionArgs.builder()
 *             .type("container")
 *             .containerProperties(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("command", jsonArray(
 *                         "ls",
 *                         "-la"
 *                     )),
 *                     jsonProperty("image", "busybox"),
 *                     jsonProperty("resourceRequirements", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("type", "VCPU"),
 *                             jsonProperty("value", "0.25")
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("type", "MEMORY"),
 *                             jsonProperty("value", "512")
 *                         )
 *                     )),
 *                     jsonProperty("volumes", jsonArray(jsonObject(
 *                         jsonProperty("host", jsonObject(
 *                             jsonProperty("sourcePath", "/tmp")
 *                         )),
 *                         jsonProperty("name", "tmp")
 *                     ))),
 *                     jsonProperty("environment", jsonArray(jsonObject(
 *                         jsonProperty("name", "VARNAME"),
 *                         jsonProperty("value", "VARVAL")
 *                     ))),
 *                     jsonProperty("mountPoints", jsonArray(jsonObject(
 *                         jsonProperty("sourceVolume", "tmp"),
 *                         jsonProperty("containerPath", "/tmp"),
 *                         jsonProperty("readOnly", false)
 *                     ))),
 *                     jsonProperty("ulimits", jsonArray(jsonObject(
 *                         jsonProperty("hardLimit", 1024),
 *                         jsonProperty("name", "nofile"),
 *                         jsonProperty("softLimit", 1024)
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ### Job definition of type multinode
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.batch.JobDefinition;
 * import com.pulumi.aws.batch.JobDefinitionArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new JobDefinition("test", JobDefinitionArgs.builder()
 *             .type("multinode")
 *             .nodeProperties(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("mainNode", 0),
 *                     jsonProperty("nodeRangeProperties", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("container", jsonObject(
 *                                 jsonProperty("command", jsonArray(
 *                                     "ls",
 *                                     "-la"
 *                                 )),
 *                                 jsonProperty("image", "busybox"),
 *                                 jsonProperty("memory", 128),
 *                                 jsonProperty("vcpus", 1)
 *                             )),
 *                             jsonProperty("targetNodes", "0:")
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("container", jsonObject(
 *                                 jsonProperty("command", jsonArray(
 *                                     "echo",
 *                                     "test"
 *                                 )),
 *                                 jsonProperty("image", "busybox"),
 *                                 jsonProperty("memory", 128),
 *                                 jsonProperty("vcpus", 1)
 *                             )),
 *                             jsonProperty("targetNodes", "1:")
 *                         )
 *                     )),
 *                     jsonProperty("numNodes", 2)
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ### Fargate Platform Capability
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.batch.JobDefinition;
 * import com.pulumi.aws.batch.JobDefinitionArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRolePolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("ecs-tasks.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var ecsTaskExecutionRole = new Role("ecsTaskExecutionRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRolePolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var ecsTaskExecutionRolePolicy = new RolePolicyAttachment("ecsTaskExecutionRolePolicy", RolePolicyAttachmentArgs.builder()
 *             .role(ecsTaskExecutionRole.name())
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AmazonECSTaskExecutionRolePolicy")
 *             .build());
 *         var test = new JobDefinition("test", JobDefinitionArgs.builder()
 *             .type("container")
 *             .platformCapabilities("FARGATE")
 *             .containerProperties(ecsTaskExecutionRole.arn().applyValue(arn -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("command", jsonArray(
 *                         "echo",
 *                         "test"
 *                     )),
 *                     jsonProperty("image", "busybox"),
 *                     jsonProperty("jobRoleArn", "arn:aws:iam::123456789012:role/AWSBatchS3ReadOnly"),
 *                     jsonProperty("fargatePlatformConfiguration", jsonObject(
 *                         jsonProperty("platformVersion", "LATEST")
 *                     )),
 *                     jsonProperty("resourceRequirements", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("type", "VCPU"),
 *                             jsonProperty("value", "0.25")
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("type", "MEMORY"),
 *                             jsonProperty("value", "512")
 *                         )
 *                     )),
 *                     jsonProperty("executionRoleArn", arn)
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Batch Job Definition using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:batch/jobDefinition:JobDefinition test arn:aws:batch:us-east-1:123456789012:job-definition/sample
 * ```
 *
 */
public class JobDefinition internal constructor(
    override val javaResource: com.pulumi.aws.batch.JobDefinition,
) : KotlinCustomResource(javaResource, JobDefinitionMapper) {
    /**
     * The Amazon Resource Name of the job definition.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A valid [container properties](http://docs.aws.amazon.com/batch/latest/APIReference/API_RegisterJobDefinition.html)
     * provided as a single valid JSON document. This parameter is required if the `type` parameter is `container`.
     */
    public val containerProperties: Output<String>?
        get() = javaResource.containerProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the name of the job definition.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A valid [node properties](http://docs.aws.amazon.com/batch/latest/APIReference/API_RegisterJobDefinition.html)
     * provided as a single valid JSON document. This parameter is required if the `type` parameter is `multinode`.
     */
    public val nodeProperties: Output<String>?
        get() = javaResource.nodeProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the parameter substitution placeholders to set in the job definition.
     */
    public val parameters: Output<Map<String, String>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The platform capabilities required by the job definition. If no value is specified, it defaults to `EC2`. To run the job on Fargate resources, specify `FARGATE`.
     */
    public val platformCapabilities: Output<List<String>>?
        get() = javaResource.platformCapabilities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Specifies whether to propagate the tags from the job definition to the corresponding Amazon ECS task. Default is `false`.
     */
    public val propagateTags: Output<Boolean>?
        get() = javaResource.propagateTags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the retry strategy to use for failed jobs that are submitted with this job definition.
     * Maximum number of `retry_strategy` is `1`.  Defined below.
     */
    public val retryStrategy: Output<JobDefinitionRetryStrategy>?
        get() = javaResource.retryStrategy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> jobDefinitionRetryStrategyToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The revision of the job definition.
     */
    public val revision: Output<Int>
        get() = javaResource.revision().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Specifies the timeout for jobs so that if a job runs longer, AWS Batch terminates the job. Maximum number of `timeout` is `1`. Defined below.
     */
    public val timeout: Output<JobDefinitionTimeout>?
        get() = javaResource.timeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    jobDefinitionTimeoutToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The type of job definition. Must be `container` or `multinode`.
     * The following arguments are optional:
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object JobDefinitionMapper : ResourceMapper<JobDefinition> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.batch.JobDefinition::class == javaResource::class

    override fun map(javaResource: Resource): JobDefinition = JobDefinition(
        javaResource as
            com.pulumi.aws.batch.JobDefinition,
    )
}

/**
 * @see [JobDefinition].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [JobDefinition].
 */
public suspend fun jobDefinition(
    name: String,
    block: suspend JobDefinitionResourceBuilder.() -> Unit,
): JobDefinition {
    val builder = JobDefinitionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [JobDefinition].
 * @param name The _unique_ name of the resulting resource.
 */
public fun jobDefinition(name: String): JobDefinition {
    val builder = JobDefinitionResourceBuilder()
    builder.name(name)
    return builder.build()
}
