@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin

import com.pulumi.aws.batch.JobDefinitionArgs.builder
import com.pulumi.aws.batch.kotlin.inputs.JobDefinitionRetryStrategyArgs
import com.pulumi.aws.batch.kotlin.inputs.JobDefinitionRetryStrategyArgsBuilder
import com.pulumi.aws.batch.kotlin.inputs.JobDefinitionTimeoutArgs
import com.pulumi.aws.batch.kotlin.inputs.JobDefinitionTimeoutArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Batch Job Definition resource.
 * ## Example Usage
 * ### Job definition of type container
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.batch.JobDefinition;
 * import com.pulumi.aws.batch.JobDefinitionArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new JobDefinition("test", JobDefinitionArgs.builder()
 *             .type("container")
 *             .containerProperties(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("command", jsonArray(
 *                         "ls",
 *                         "-la"
 *                     )),
 *                     jsonProperty("image", "busybox"),
 *                     jsonProperty("resourceRequirements", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("type", "VCPU"),
 *                             jsonProperty("value", "0.25")
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("type", "MEMORY"),
 *                             jsonProperty("value", "512")
 *                         )
 *                     )),
 *                     jsonProperty("volumes", jsonArray(jsonObject(
 *                         jsonProperty("host", jsonObject(
 *                             jsonProperty("sourcePath", "/tmp")
 *                         )),
 *                         jsonProperty("name", "tmp")
 *                     ))),
 *                     jsonProperty("environment", jsonArray(jsonObject(
 *                         jsonProperty("name", "VARNAME"),
 *                         jsonProperty("value", "VARVAL")
 *                     ))),
 *                     jsonProperty("mountPoints", jsonArray(jsonObject(
 *                         jsonProperty("sourceVolume", "tmp"),
 *                         jsonProperty("containerPath", "/tmp"),
 *                         jsonProperty("readOnly", false)
 *                     ))),
 *                     jsonProperty("ulimits", jsonArray(jsonObject(
 *                         jsonProperty("hardLimit", 1024),
 *                         jsonProperty("name", "nofile"),
 *                         jsonProperty("softLimit", 1024)
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ### Job definition of type multinode
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.batch.JobDefinition;
 * import com.pulumi.aws.batch.JobDefinitionArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new JobDefinition("test", JobDefinitionArgs.builder()
 *             .type("multinode")
 *             .nodeProperties(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("mainNode", 0),
 *                     jsonProperty("nodeRangeProperties", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("container", jsonObject(
 *                                 jsonProperty("command", jsonArray(
 *                                     "ls",
 *                                     "-la"
 *                                 )),
 *                                 jsonProperty("image", "busybox"),
 *                                 jsonProperty("memory", 128),
 *                                 jsonProperty("vcpus", 1)
 *                             )),
 *                             jsonProperty("targetNodes", "0:")
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("container", jsonObject(
 *                                 jsonProperty("command", jsonArray(
 *                                     "echo",
 *                                     "test"
 *                                 )),
 *                                 jsonProperty("image", "busybox"),
 *                                 jsonProperty("memory", 128),
 *                                 jsonProperty("vcpus", 1)
 *                             )),
 *                             jsonProperty("targetNodes", "1:")
 *                         )
 *                     )),
 *                     jsonProperty("numNodes", 2)
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ### Fargate Platform Capability
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.batch.JobDefinition;
 * import com.pulumi.aws.batch.JobDefinitionArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRolePolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("ecs-tasks.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var ecsTaskExecutionRole = new Role("ecsTaskExecutionRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRolePolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var ecsTaskExecutionRolePolicy = new RolePolicyAttachment("ecsTaskExecutionRolePolicy", RolePolicyAttachmentArgs.builder()
 *             .role(ecsTaskExecutionRole.name())
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AmazonECSTaskExecutionRolePolicy")
 *             .build());
 *         var test = new JobDefinition("test", JobDefinitionArgs.builder()
 *             .type("container")
 *             .platformCapabilities("FARGATE")
 *             .containerProperties(ecsTaskExecutionRole.arn().applyValue(arn -> serializeJson(
 *                 jsonObject(
 *                     jsonProperty("command", jsonArray(
 *                         "echo",
 *                         "test"
 *                     )),
 *                     jsonProperty("image", "busybox"),
 *                     jsonProperty("jobRoleArn", "arn:aws:iam::123456789012:role/AWSBatchS3ReadOnly"),
 *                     jsonProperty("fargatePlatformConfiguration", jsonObject(
 *                         jsonProperty("platformVersion", "LATEST")
 *                     )),
 *                     jsonProperty("resourceRequirements", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("type", "VCPU"),
 *                             jsonProperty("value", "0.25")
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("type", "MEMORY"),
 *                             jsonProperty("value", "512")
 *                         )
 *                     )),
 *                     jsonProperty("executionRoleArn", arn)
 *                 ))))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Batch Job Definition using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:batch/jobDefinition:JobDefinition test arn:aws:batch:us-east-1:123456789012:job-definition/sample
 * ```
 * @property containerProperties A valid [container properties](http://docs.aws.amazon.com/batch/latest/APIReference/API_RegisterJobDefinition.html)
 * provided as a single valid JSON document. This parameter is required if the `type` parameter is `container`.
 * @property name Specifies the name of the job definition.
 * @property nodeProperties A valid [node properties](http://docs.aws.amazon.com/batch/latest/APIReference/API_RegisterJobDefinition.html)
 * provided as a single valid JSON document. This parameter is required if the `type` parameter is `multinode`.
 * @property parameters Specifies the parameter substitution placeholders to set in the job definition.
 * @property platformCapabilities The platform capabilities required by the job definition. If no value is specified, it defaults to `EC2`. To run the job on Fargate resources, specify `FARGATE`.
 * @property propagateTags Specifies whether to propagate the tags from the job definition to the corresponding Amazon ECS task. Default is `false`.
 * @property retryStrategy Specifies the retry strategy to use for failed jobs that are submitted with this job definition.
 * Maximum number of `retry_strategy` is `1`.  Defined below.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeout Specifies the timeout for jobs so that if a job runs longer, AWS Batch terminates the job. Maximum number of `timeout` is `1`. Defined below.
 * @property type The type of job definition. Must be `container` or `multinode`.
 * The following arguments are optional:
 */
public data class JobDefinitionArgs(
    public val containerProperties: Output<String>? = null,
    public val name: Output<String>? = null,
    public val nodeProperties: Output<String>? = null,
    public val parameters: Output<Map<String, String>>? = null,
    public val platformCapabilities: Output<List<String>>? = null,
    public val propagateTags: Output<Boolean>? = null,
    public val retryStrategy: Output<JobDefinitionRetryStrategyArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeout: Output<JobDefinitionTimeoutArgs>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.batch.JobDefinitionArgs> {
    override fun toJava(): com.pulumi.aws.batch.JobDefinitionArgs =
        com.pulumi.aws.batch.JobDefinitionArgs.builder()
            .containerProperties(containerProperties?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .nodeProperties(nodeProperties?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .platformCapabilities(platformCapabilities?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .propagateTags(propagateTags?.applyValue({ args0 -> args0 }))
            .retryStrategy(retryStrategy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeout(timeout?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobDefinitionArgs].
 */
@PulumiTagMarker
public class JobDefinitionArgsBuilder internal constructor() {
    private var containerProperties: Output<String>? = null

    private var name: Output<String>? = null

    private var nodeProperties: Output<String>? = null

    private var parameters: Output<Map<String, String>>? = null

    private var platformCapabilities: Output<List<String>>? = null

    private var propagateTags: Output<Boolean>? = null

    private var retryStrategy: Output<JobDefinitionRetryStrategyArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeout: Output<JobDefinitionTimeoutArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value A valid [container properties](http://docs.aws.amazon.com/batch/latest/APIReference/API_RegisterJobDefinition.html)
     * provided as a single valid JSON document. This parameter is required if the `type` parameter is `container`.
     */
    @JvmName("mwpatrxulxifmsgn")
    public suspend fun containerProperties(`value`: Output<String>) {
        this.containerProperties = value
    }

    /**
     * @param value Specifies the name of the job definition.
     */
    @JvmName("hokrckwhphfbedxu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A valid [node properties](http://docs.aws.amazon.com/batch/latest/APIReference/API_RegisterJobDefinition.html)
     * provided as a single valid JSON document. This parameter is required if the `type` parameter is `multinode`.
     */
    @JvmName("suvatsjbwwmkwufj")
    public suspend fun nodeProperties(`value`: Output<String>) {
        this.nodeProperties = value
    }

    /**
     * @param value Specifies the parameter substitution placeholders to set in the job definition.
     */
    @JvmName("yuackjbqmlmnjgok")
    public suspend fun parameters(`value`: Output<Map<String, String>>) {
        this.parameters = value
    }

    /**
     * @param value The platform capabilities required by the job definition. If no value is specified, it defaults to `EC2`. To run the job on Fargate resources, specify `FARGATE`.
     */
    @JvmName("btwphqurssxkcxix")
    public suspend fun platformCapabilities(`value`: Output<List<String>>) {
        this.platformCapabilities = value
    }

    @JvmName("shfchewjwinhonnm")
    public suspend fun platformCapabilities(vararg values: Output<String>) {
        this.platformCapabilities = Output.all(values.asList())
    }

    /**
     * @param values The platform capabilities required by the job definition. If no value is specified, it defaults to `EC2`. To run the job on Fargate resources, specify `FARGATE`.
     */
    @JvmName("aahdjoitlncwgxlq")
    public suspend fun platformCapabilities(values: List<Output<String>>) {
        this.platformCapabilities = Output.all(values)
    }

    /**
     * @param value Specifies whether to propagate the tags from the job definition to the corresponding Amazon ECS task. Default is `false`.
     */
    @JvmName("dcxewofbcwvbkdie")
    public suspend fun propagateTags(`value`: Output<Boolean>) {
        this.propagateTags = value
    }

    /**
     * @param value Specifies the retry strategy to use for failed jobs that are submitted with this job definition.
     * Maximum number of `retry_strategy` is `1`.  Defined below.
     */
    @JvmName("gsrgotwdevukyxwd")
    public suspend fun retryStrategy(`value`: Output<JobDefinitionRetryStrategyArgs>) {
        this.retryStrategy = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("toyomoxrglpnknna")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the timeout for jobs so that if a job runs longer, AWS Batch terminates the job. Maximum number of `timeout` is `1`. Defined below.
     */
    @JvmName("utlyeupkmbbojdgl")
    public suspend fun timeout(`value`: Output<JobDefinitionTimeoutArgs>) {
        this.timeout = value
    }

    /**
     * @param value The type of job definition. Must be `container` or `multinode`.
     * The following arguments are optional:
     */
    @JvmName("mcmxmdpysqnvvgad")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value A valid [container properties](http://docs.aws.amazon.com/batch/latest/APIReference/API_RegisterJobDefinition.html)
     * provided as a single valid JSON document. This parameter is required if the `type` parameter is `container`.
     */
    @JvmName("guxpmcfjmskvcicq")
    public suspend fun containerProperties(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerProperties = mapped
    }

    /**
     * @param value Specifies the name of the job definition.
     */
    @JvmName("xkkaepiaxvexlqsm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A valid [node properties](http://docs.aws.amazon.com/batch/latest/APIReference/API_RegisterJobDefinition.html)
     * provided as a single valid JSON document. This parameter is required if the `type` parameter is `multinode`.
     */
    @JvmName("lqxmhyabpavrmmuj")
    public suspend fun nodeProperties(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeProperties = mapped
    }

    /**
     * @param value Specifies the parameter substitution placeholders to set in the job definition.
     */
    @JvmName("mfeqpbqprutdulue")
    public suspend fun parameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values Specifies the parameter substitution placeholders to set in the job definition.
     */
    @JvmName("meqwpsikpljmusap")
    public fun parameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The platform capabilities required by the job definition. If no value is specified, it defaults to `EC2`. To run the job on Fargate resources, specify `FARGATE`.
     */
    @JvmName("exleunfjyjbqvymo")
    public suspend fun platformCapabilities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platformCapabilities = mapped
    }

    /**
     * @param values The platform capabilities required by the job definition. If no value is specified, it defaults to `EC2`. To run the job on Fargate resources, specify `FARGATE`.
     */
    @JvmName("jgftvpcrunfeepok")
    public suspend fun platformCapabilities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.platformCapabilities = mapped
    }

    /**
     * @param value Specifies whether to propagate the tags from the job definition to the corresponding Amazon ECS task. Default is `false`.
     */
    @JvmName("xdobqijtbivqccup")
    public suspend fun propagateTags(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propagateTags = mapped
    }

    /**
     * @param value Specifies the retry strategy to use for failed jobs that are submitted with this job definition.
     * Maximum number of `retry_strategy` is `1`.  Defined below.
     */
    @JvmName("csijwguiycybhxyv")
    public suspend fun retryStrategy(`value`: JobDefinitionRetryStrategyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryStrategy = mapped
    }

    /**
     * @param argument Specifies the retry strategy to use for failed jobs that are submitted with this job definition.
     * Maximum number of `retry_strategy` is `1`.  Defined below.
     */
    @JvmName("utypuylwcxbjlvno")
    public suspend
    fun retryStrategy(argument: suspend JobDefinitionRetryStrategyArgsBuilder.() -> Unit) {
        val toBeMapped = JobDefinitionRetryStrategyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retryStrategy = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pgivcttnkcmkjavb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cymnycxgkaoawydr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies the timeout for jobs so that if a job runs longer, AWS Batch terminates the job. Maximum number of `timeout` is `1`. Defined below.
     */
    @JvmName("lxsowxnclhplofwg")
    public suspend fun timeout(`value`: JobDefinitionTimeoutArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    /**
     * @param argument Specifies the timeout for jobs so that if a job runs longer, AWS Batch terminates the job. Maximum number of `timeout` is `1`. Defined below.
     */
    @JvmName("bqbhhdtvpnndytbw")
    public suspend fun timeout(argument: suspend JobDefinitionTimeoutArgsBuilder.() -> Unit) {
        val toBeMapped = JobDefinitionTimeoutArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeout = mapped
    }

    /**
     * @param value The type of job definition. Must be `container` or `multinode`.
     * The following arguments are optional:
     */
    @JvmName("awdcgvbrfoaxarey")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): JobDefinitionArgs = JobDefinitionArgs(
        containerProperties = containerProperties,
        name = name,
        nodeProperties = nodeProperties,
        parameters = parameters,
        platformCapabilities = platformCapabilities,
        propagateTags = propagateTags,
        retryStrategy = retryStrategy,
        tags = tags,
        timeout = timeout,
        type = type,
    )
}
