@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin

import com.pulumi.aws.batch.kotlin.outputs.JobQueueTimeouts
import com.pulumi.aws.batch.kotlin.outputs.JobQueueTimeouts.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [JobQueue].
 */
@PulumiTagMarker
public class JobQueueResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: JobQueueArgs = JobQueueArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend JobQueueArgsBuilder.() -> Unit) {
        val builder = JobQueueArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): JobQueue {
        val builtJavaResource = com.pulumi.aws.batch.JobQueue(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return JobQueue(builtJavaResource)
    }
}

/**
 * Provides a Batch Job Queue resource.
 * ## Example Usage
 * ### Basic Job Queue
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.batch.JobQueue;
 * import com.pulumi.aws.batch.JobQueueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testQueue = new JobQueue("testQueue", JobQueueArgs.builder()
 *             .state("ENABLED")
 *             .priority(1)
 *             .computeEnvironments(
 *                 aws_batch_compute_environment.test_environment_1().arn(),
 *                 aws_batch_compute_environment.test_environment_2().arn())
 *             .build());
 *     }
 * }
 * ```
 * ### Job Queue with a fair share scheduling policy
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.batch.SchedulingPolicy;
 * import com.pulumi.aws.batch.SchedulingPolicyArgs;
 * import com.pulumi.aws.batch.inputs.SchedulingPolicyFairSharePolicyArgs;
 * import com.pulumi.aws.batch.JobQueue;
 * import com.pulumi.aws.batch.JobQueueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleSchedulingPolicy = new SchedulingPolicy("exampleSchedulingPolicy", SchedulingPolicyArgs.builder()
 *             .fairSharePolicy(SchedulingPolicyFairSharePolicyArgs.builder()
 *                 .computeReservation(1)
 *                 .shareDecaySeconds(3600)
 *                 .shareDistributions(SchedulingPolicyFairSharePolicyShareDistributionArgs.builder()
 *                     .shareIdentifier("A1*")
 *                     .weightFactor(0.1)
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleJobQueue = new JobQueue("exampleJobQueue", JobQueueArgs.builder()
 *             .schedulingPolicyArn(exampleSchedulingPolicy.arn())
 *             .state("ENABLED")
 *             .priority(1)
 *             .computeEnvironments(
 *                 aws_batch_compute_environment.test_environment_1().arn(),
 *                 aws_batch_compute_environment.test_environment_2().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Batch Job Queue using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:batch/jobQueue:JobQueue test_queue arn:aws:batch:us-east-1:123456789012:job-queue/sample
 * ```
 *
 */
public class JobQueue internal constructor(
    override val javaResource: com.pulumi.aws.batch.JobQueue,
) : KotlinCustomResource(javaResource, JobQueueMapper) {
    /**
     * The Amazon Resource Name of the job queue.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * List of compute environment ARNs mapped to a job queue.
     * The position of the compute environments in the list will dictate the order.
     */
    public val computeEnvironments: Output<List<String>>
        get() = javaResource.computeEnvironments().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Specifies the name of the job queue.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The priority of the job queue. Job queues with a higher priority
     * are evaluated first when associated with the same compute environment.
     */
    public val priority: Output<Int>
        get() = javaResource.priority().applyValue({ args0 -> args0 })

    /**
     * The ARN of the fair share scheduling policy. If this parameter is specified, the job queue uses a fair share scheduling policy. If this parameter isn't specified, the job queue uses a first in, first out (FIFO) scheduling policy. After a job queue is created, you can replace but can't remove the fair share scheduling policy.
     */
    public val schedulingPolicyArn: Output<String>?
        get() = javaResource.schedulingPolicyArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The state of the job queue. Must be one of: `ENABLED` or `DISABLED`
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val timeouts: Output<JobQueueTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })
}

public object JobQueueMapper : ResourceMapper<JobQueue> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.batch.JobQueue::class == javaResource::class

    override fun map(javaResource: Resource): JobQueue = JobQueue(
        javaResource as
            com.pulumi.aws.batch.JobQueue,
    )
}

/**
 * @see [JobQueue].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [JobQueue].
 */
public suspend fun jobQueue(name: String, block: suspend JobQueueResourceBuilder.() -> Unit):
    JobQueue {
    val builder = JobQueueResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [JobQueue].
 * @param name The _unique_ name of the resulting resource.
 */
public fun jobQueue(name: String): JobQueue {
    val builder = JobQueueResourceBuilder()
    builder.name(name)
    return builder.build()
}
