@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin

import com.pulumi.aws.batch.JobQueueArgs.builder
import com.pulumi.aws.batch.kotlin.inputs.JobQueueTimeoutsArgs
import com.pulumi.aws.batch.kotlin.inputs.JobQueueTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Batch Job Queue resource.
 * ## Example Usage
 * ### Basic Job Queue
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.batch.JobQueue;
 * import com.pulumi.aws.batch.JobQueueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testQueue = new JobQueue("testQueue", JobQueueArgs.builder()
 *             .state("ENABLED")
 *             .priority(1)
 *             .computeEnvironments(
 *                 aws_batch_compute_environment.test_environment_1().arn(),
 *                 aws_batch_compute_environment.test_environment_2().arn())
 *             .build());
 *     }
 * }
 * ```
 * ### Job Queue with a fair share scheduling policy
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.batch.SchedulingPolicy;
 * import com.pulumi.aws.batch.SchedulingPolicyArgs;
 * import com.pulumi.aws.batch.inputs.SchedulingPolicyFairSharePolicyArgs;
 * import com.pulumi.aws.batch.JobQueue;
 * import com.pulumi.aws.batch.JobQueueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleSchedulingPolicy = new SchedulingPolicy("exampleSchedulingPolicy", SchedulingPolicyArgs.builder()
 *             .fairSharePolicy(SchedulingPolicyFairSharePolicyArgs.builder()
 *                 .computeReservation(1)
 *                 .shareDecaySeconds(3600)
 *                 .shareDistributions(SchedulingPolicyFairSharePolicyShareDistributionArgs.builder()
 *                     .shareIdentifier("A1*")
 *                     .weightFactor(0.1)
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleJobQueue = new JobQueue("exampleJobQueue", JobQueueArgs.builder()
 *             .schedulingPolicyArn(exampleSchedulingPolicy.arn())
 *             .state("ENABLED")
 *             .priority(1)
 *             .computeEnvironments(
 *                 aws_batch_compute_environment.test_environment_1().arn(),
 *                 aws_batch_compute_environment.test_environment_2().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Batch Job Queue using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:batch/jobQueue:JobQueue test_queue arn:aws:batch:us-east-1:123456789012:job-queue/sample
 * ```
 * @property computeEnvironments List of compute environment ARNs mapped to a job queue.
 * The position of the compute environments in the list will dictate the order.
 * @property name Specifies the name of the job queue.
 * @property priority The priority of the job queue. Job queues with a higher priority
 * are evaluated first when associated with the same compute environment.
 * @property schedulingPolicyArn The ARN of the fair share scheduling policy. If this parameter is specified, the job queue uses a fair share scheduling policy. If this parameter isn't specified, the job queue uses a first in, first out (FIFO) scheduling policy. After a job queue is created, you can replace but can't remove the fair share scheduling policy.
 * @property state The state of the job queue. Must be one of: `ENABLED` or `DISABLED`
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeouts
 */
public data class JobQueueArgs(
    public val computeEnvironments: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val schedulingPolicyArn: Output<String>? = null,
    public val state: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<JobQueueTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.batch.JobQueueArgs> {
    override fun toJava(): com.pulumi.aws.batch.JobQueueArgs =
        com.pulumi.aws.batch.JobQueueArgs.builder()
            .computeEnvironments(computeEnvironments?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .schedulingPolicyArn(schedulingPolicyArn?.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [JobQueueArgs].
 */
@PulumiTagMarker
public class JobQueueArgsBuilder internal constructor() {
    private var computeEnvironments: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var schedulingPolicyArn: Output<String>? = null

    private var state: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<JobQueueTimeoutsArgs>? = null

    /**
     * @param value List of compute environment ARNs mapped to a job queue.
     * The position of the compute environments in the list will dictate the order.
     */
    @JvmName("frdggxxabfbcdwjg")
    public suspend fun computeEnvironments(`value`: Output<List<String>>) {
        this.computeEnvironments = value
    }

    @JvmName("jaonstovfkiyfian")
    public suspend fun computeEnvironments(vararg values: Output<String>) {
        this.computeEnvironments = Output.all(values.asList())
    }

    /**
     * @param values List of compute environment ARNs mapped to a job queue.
     * The position of the compute environments in the list will dictate the order.
     */
    @JvmName("ophbjwakygtxqppp")
    public suspend fun computeEnvironments(values: List<Output<String>>) {
        this.computeEnvironments = Output.all(values)
    }

    /**
     * @param value Specifies the name of the job queue.
     */
    @JvmName("fscewupphawwjxwn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The priority of the job queue. Job queues with a higher priority
     * are evaluated first when associated with the same compute environment.
     */
    @JvmName("vokmmrturvxatcni")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The ARN of the fair share scheduling policy. If this parameter is specified, the job queue uses a fair share scheduling policy. If this parameter isn't specified, the job queue uses a first in, first out (FIFO) scheduling policy. After a job queue is created, you can replace but can't remove the fair share scheduling policy.
     */
    @JvmName("dpmbrmybxikyxois")
    public suspend fun schedulingPolicyArn(`value`: Output<String>) {
        this.schedulingPolicyArn = value
    }

    /**
     * @param value The state of the job queue. Must be one of: `ENABLED` or `DISABLED`
     */
    @JvmName("srhujuygxgbjwnrt")
    public suspend fun state(`value`: Output<String>) {
        this.state = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lttttepjuenjljqb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("xkvovimvudpkrxko")
    public suspend fun timeouts(`value`: Output<JobQueueTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value List of compute environment ARNs mapped to a job queue.
     * The position of the compute environments in the list will dictate the order.
     */
    @JvmName("sbveusykpbssaeha")
    public suspend fun computeEnvironments(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeEnvironments = mapped
    }

    /**
     * @param values List of compute environment ARNs mapped to a job queue.
     * The position of the compute environments in the list will dictate the order.
     */
    @JvmName("nhjeyxtghjreqccb")
    public suspend fun computeEnvironments(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.computeEnvironments = mapped
    }

    /**
     * @param value Specifies the name of the job queue.
     */
    @JvmName("rbdmreneelgpnvno")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The priority of the job queue. Job queues with a higher priority
     * are evaluated first when associated with the same compute environment.
     */
    @JvmName("rojlgtptocygcvlu")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The ARN of the fair share scheduling policy. If this parameter is specified, the job queue uses a fair share scheduling policy. If this parameter isn't specified, the job queue uses a first in, first out (FIFO) scheduling policy. After a job queue is created, you can replace but can't remove the fair share scheduling policy.
     */
    @JvmName("mbfbvlunfpfxkkpu")
    public suspend fun schedulingPolicyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedulingPolicyArn = mapped
    }

    /**
     * @param value The state of the job queue. Must be one of: `ENABLED` or `DISABLED`
     */
    @JvmName("nkxajneawefxxcpf")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nqbdofxvntylrplh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eauafnkhtudubyfs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("yerosipxmngbikmp")
    public suspend fun timeouts(`value`: JobQueueTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("hvtchxelkslighvt")
    public suspend fun timeouts(argument: suspend JobQueueTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = JobQueueTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): JobQueueArgs = JobQueueArgs(
        computeEnvironments = computeEnvironments,
        name = name,
        priority = priority,
        schedulingPolicyArn = schedulingPolicyArn,
        state = state,
        tags = tags,
        timeouts = timeouts,
    )
}
