@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin

import com.pulumi.aws.batch.SchedulingPolicyArgs.builder
import com.pulumi.aws.batch.kotlin.inputs.SchedulingPolicyFairSharePolicyArgs
import com.pulumi.aws.batch.kotlin.inputs.SchedulingPolicyFairSharePolicyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Batch Scheduling Policy resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.batch.SchedulingPolicy;
 * import com.pulumi.aws.batch.SchedulingPolicyArgs;
 * import com.pulumi.aws.batch.inputs.SchedulingPolicyFairSharePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SchedulingPolicy("example", SchedulingPolicyArgs.builder()
 *             .fairSharePolicy(SchedulingPolicyFairSharePolicyArgs.builder()
 *                 .computeReservation(1)
 *                 .shareDecaySeconds(3600)
 *                 .shareDistributions(
 *                     SchedulingPolicyFairSharePolicyShareDistributionArgs.builder()
 *                         .shareIdentifier("A1*")
 *                         .weightFactor(0.1)
 *                         .build(),
 *                     SchedulingPolicyFairSharePolicyShareDistributionArgs.builder()
 *                         .shareIdentifier("A2")
 *                         .weightFactor(0.2)
 *                         .build())
 *                 .build())
 *             .tags(Map.of("Name", "Example Batch Scheduling Policy"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Batch Scheduling Policy using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:batch/schedulingPolicy:SchedulingPolicy test_policy arn:aws:batch:us-east-1:123456789012:scheduling-policy/sample
 * ```
 * @property fairSharePolicy
 * @property name Specifies the name of the scheduling policy.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class SchedulingPolicyArgs(
    public val fairSharePolicy: Output<SchedulingPolicyFairSharePolicyArgs>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.batch.SchedulingPolicyArgs> {
    override fun toJava(): com.pulumi.aws.batch.SchedulingPolicyArgs =
        com.pulumi.aws.batch.SchedulingPolicyArgs.builder()
            .fairSharePolicy(fairSharePolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SchedulingPolicyArgs].
 */
@PulumiTagMarker
public class SchedulingPolicyArgsBuilder internal constructor() {
    private var fairSharePolicy: Output<SchedulingPolicyFairSharePolicyArgs>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value
     */
    @JvmName("nncuprgudkxhpaka")
    public suspend fun fairSharePolicy(`value`: Output<SchedulingPolicyFairSharePolicyArgs>) {
        this.fairSharePolicy = value
    }

    /**
     * @param value Specifies the name of the scheduling policy.
     */
    @JvmName("lhvrewdwvvgsqrsg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nfrplegdlwmrnnil")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("pajjcrufnsjeuhay")
    public suspend fun fairSharePolicy(`value`: SchedulingPolicyFairSharePolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fairSharePolicy = mapped
    }

    /**
     * @param argument
     */
    @JvmName("whvghgdlyqmtgryd")
    public suspend
    fun fairSharePolicy(argument: suspend SchedulingPolicyFairSharePolicyArgsBuilder.() -> Unit) {
        val toBeMapped = SchedulingPolicyFairSharePolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.fairSharePolicy = mapped
    }

    /**
     * @param value Specifies the name of the scheduling policy.
     */
    @JvmName("nslrraimaqgevslj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lvycffabxhgltbuw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("illaidkfqhbejxuy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SchedulingPolicyArgs = SchedulingPolicyArgs(
        fairSharePolicy = fairSharePolicy,
        name = name,
        tags = tags,
    )
}
