@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.inputs

import com.pulumi.aws.batch.inputs.ComputeEnvironmentComputeResourcesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property allocationStrategy The allocation strategy to use for the compute resource in case not enough instances of the best fitting instance type can be allocated. Valid items are `BEST_FIT_PROGRESSIVE`, `SPOT_CAPACITY_OPTIMIZED` or `BEST_FIT`. Defaults to `BEST_FIT`. See [AWS docs](https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html) for details. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
 * @property bidPercentage Integer of maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched. For example, if your bid percentage is 20% (`20`), then the Spot price must be below 20% of the current On-Demand price for that EC2 instance. If you leave this field empty, the default value is 100% of the On-Demand price. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
 * @property desiredVcpus The desired number of EC2 vCPUS in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
 * @property ec2Configurations Provides information used to select Amazon Machine Images (AMIs) for EC2 instances in the compute environment. If Ec2Configuration isn't specified, the default is ECS_AL2. This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
 * @property ec2KeyPair The EC2 key pair that is used for instances launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
 * @property imageId The Amazon Machine Image (AMI) ID used for instances launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified. (Deprecated, use `ec2_configuration` `image_id_override` instead)
 * @property instanceRole The Amazon ECS instance role applied to Amazon EC2 instances in a compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
 * @property instanceTypes A list of instance types that may be launched. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
 * @property launchTemplate The launch template to use for your compute resources. See details below. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
 * @property maxVcpus The maximum number of EC2 vCPUs that an environment can reach.
 * @property minVcpus The minimum number of EC2 vCPUs that an environment should maintain. For `EC2` or `SPOT` compute environments, if the parameter is not explicitly defined, a `0` default value will be set. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
 * @property placementGroup The Amazon EC2 placement group to associate with your compute resources.
 * @property securityGroupIds A list of EC2 security group that are associated with instances launched in the compute environment. This parameter is required for Fargate compute environments.
 * @property spotIamFleetRole The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied to a SPOT compute environment. This parameter is required for SPOT compute environments. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
 * @property subnets A list of VPC subnets into which the compute resources are launched.
 * @property tags Key-value pair tags to be applied to resources that are launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
 * @property type The type of compute environment. Valid items are `EC2`, `SPOT`, `FARGATE` or `FARGATE_SPOT`.
 */
public data class ComputeEnvironmentComputeResourcesArgs(
    public val allocationStrategy: Output<String>? = null,
    public val bidPercentage: Output<Int>? = null,
    public val desiredVcpus: Output<Int>? = null,
    public val ec2Configurations:
    Output<List<ComputeEnvironmentComputeResourcesEc2ConfigurationArgs>>? = null,
    public val ec2KeyPair: Output<String>? = null,
    public val imageId: Output<String>? = null,
    public val instanceRole: Output<String>? = null,
    public val instanceTypes: Output<List<String>>? = null,
    public val launchTemplate: Output<ComputeEnvironmentComputeResourcesLaunchTemplateArgs>? = null,
    public val maxVcpus: Output<Int>,
    public val minVcpus: Output<Int>? = null,
    public val placementGroup: Output<String>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val spotIamFleetRole: Output<String>? = null,
    public val subnets: Output<List<String>>,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.batch.inputs.ComputeEnvironmentComputeResourcesArgs> {
    override fun toJava(): com.pulumi.aws.batch.inputs.ComputeEnvironmentComputeResourcesArgs =
        com.pulumi.aws.batch.inputs.ComputeEnvironmentComputeResourcesArgs.builder()
            .allocationStrategy(allocationStrategy?.applyValue({ args0 -> args0 }))
            .bidPercentage(bidPercentage?.applyValue({ args0 -> args0 }))
            .desiredVcpus(desiredVcpus?.applyValue({ args0 -> args0 }))
            .ec2Configurations(
                ec2Configurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ec2KeyPair(ec2KeyPair?.applyValue({ args0 -> args0 }))
            .imageId(imageId?.applyValue({ args0 -> args0 }))
            .instanceRole(instanceRole?.applyValue({ args0 -> args0 }))
            .instanceTypes(instanceTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .launchTemplate(launchTemplate?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .maxVcpus(maxVcpus.applyValue({ args0 -> args0 }))
            .minVcpus(minVcpus?.applyValue({ args0 -> args0 }))
            .placementGroup(placementGroup?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .spotIamFleetRole(spotIamFleetRole?.applyValue({ args0 -> args0 }))
            .subnets(subnets.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ComputeEnvironmentComputeResourcesArgs].
 */
@PulumiTagMarker
public class ComputeEnvironmentComputeResourcesArgsBuilder internal constructor() {
    private var allocationStrategy: Output<String>? = null

    private var bidPercentage: Output<Int>? = null

    private var desiredVcpus: Output<Int>? = null

    private var ec2Configurations:
        Output<List<ComputeEnvironmentComputeResourcesEc2ConfigurationArgs>>? = null

    private var ec2KeyPair: Output<String>? = null

    private var imageId: Output<String>? = null

    private var instanceRole: Output<String>? = null

    private var instanceTypes: Output<List<String>>? = null

    private var launchTemplate: Output<ComputeEnvironmentComputeResourcesLaunchTemplateArgs>? = null

    private var maxVcpus: Output<Int>? = null

    private var minVcpus: Output<Int>? = null

    private var placementGroup: Output<String>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var spotIamFleetRole: Output<String>? = null

    private var subnets: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value The allocation strategy to use for the compute resource in case not enough instances of the best fitting instance type can be allocated. Valid items are `BEST_FIT_PROGRESSIVE`, `SPOT_CAPACITY_OPTIMIZED` or `BEST_FIT`. Defaults to `BEST_FIT`. See [AWS docs](https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html) for details. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
     */
    @JvmName("apgeftbepscpsgsu")
    public suspend fun allocationStrategy(`value`: Output<String>) {
        this.allocationStrategy = value
    }

    /**
     * @param value Integer of maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched. For example, if your bid percentage is 20% (`20`), then the Spot price must be below 20% of the current On-Demand price for that EC2 instance. If you leave this field empty, the default value is 100% of the On-Demand price. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
     */
    @JvmName("jesodvhgosjafhlj")
    public suspend fun bidPercentage(`value`: Output<Int>) {
        this.bidPercentage = value
    }

    /**
     * @param value The desired number of EC2 vCPUS in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
     */
    @JvmName("ybflmsqnkhtkkyho")
    public suspend fun desiredVcpus(`value`: Output<Int>) {
        this.desiredVcpus = value
    }

    /**
     * @param value Provides information used to select Amazon Machine Images (AMIs) for EC2 instances in the compute environment. If Ec2Configuration isn't specified, the default is ECS_AL2. This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     */
    @JvmName("bgeawkdpdjvdgdog")
    public suspend
    fun ec2Configurations(`value`: Output<List<ComputeEnvironmentComputeResourcesEc2ConfigurationArgs>>) {
        this.ec2Configurations = value
    }

    @JvmName("sdfnsiuxlogaskkb")
    public suspend fun ec2Configurations(
        vararg
        values: Output<ComputeEnvironmentComputeResourcesEc2ConfigurationArgs>,
    ) {
        this.ec2Configurations = Output.all(values.asList())
    }

    /**
     * @param values Provides information used to select Amazon Machine Images (AMIs) for EC2 instances in the compute environment. If Ec2Configuration isn't specified, the default is ECS_AL2. This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     */
    @JvmName("mnlrauyoajiqitae")
    public suspend
    fun ec2Configurations(values: List<Output<ComputeEnvironmentComputeResourcesEc2ConfigurationArgs>>) {
        this.ec2Configurations = Output.all(values)
    }

    /**
     * @param value The EC2 key pair that is used for instances launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
     */
    @JvmName("hgmnoopreybksqbk")
    public suspend fun ec2KeyPair(`value`: Output<String>) {
        this.ec2KeyPair = value
    }

    /**
     * @param value The Amazon Machine Image (AMI) ID used for instances launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified. (Deprecated, use `ec2_configuration` `image_id_override` instead)
     */
    @JvmName("qmcihiijqekspukm")
    public suspend fun imageId(`value`: Output<String>) {
        this.imageId = value
    }

    /**
     * @param value The Amazon ECS instance role applied to Amazon EC2 instances in a compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
     */
    @JvmName("sjjpfvxiebljvehu")
    public suspend fun instanceRole(`value`: Output<String>) {
        this.instanceRole = value
    }

    /**
     * @param value A list of instance types that may be launched. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
     */
    @JvmName("iwxvledecpifmsqm")
    public suspend fun instanceTypes(`value`: Output<List<String>>) {
        this.instanceTypes = value
    }

    @JvmName("gdrejyhlslpjhmlw")
    public suspend fun instanceTypes(vararg values: Output<String>) {
        this.instanceTypes = Output.all(values.asList())
    }

    /**
     * @param values A list of instance types that may be launched. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
     */
    @JvmName("vekuwsehixtfjqfp")
    public suspend fun instanceTypes(values: List<Output<String>>) {
        this.instanceTypes = Output.all(values)
    }

    /**
     * @param value The launch template to use for your compute resources. See details below. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
     */
    @JvmName("rvjfwdxibjtjuadj")
    public suspend
    fun launchTemplate(`value`: Output<ComputeEnvironmentComputeResourcesLaunchTemplateArgs>) {
        this.launchTemplate = value
    }

    /**
     * @param value The maximum number of EC2 vCPUs that an environment can reach.
     */
    @JvmName("lgreukcwdaxkldgo")
    public suspend fun maxVcpus(`value`: Output<Int>) {
        this.maxVcpus = value
    }

    /**
     * @param value The minimum number of EC2 vCPUs that an environment should maintain. For `EC2` or `SPOT` compute environments, if the parameter is not explicitly defined, a `0` default value will be set. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
     */
    @JvmName("xrqnhdjwmqtwdyrf")
    public suspend fun minVcpus(`value`: Output<Int>) {
        this.minVcpus = value
    }

    /**
     * @param value The Amazon EC2 placement group to associate with your compute resources.
     */
    @JvmName("vhivaruvfrygncab")
    public suspend fun placementGroup(`value`: Output<String>) {
        this.placementGroup = value
    }

    /**
     * @param value A list of EC2 security group that are associated with instances launched in the compute environment. This parameter is required for Fargate compute environments.
     */
    @JvmName("qlgqulinakdjifgw")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("ugskhchwyrkohaqe")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values A list of EC2 security group that are associated with instances launched in the compute environment. This parameter is required for Fargate compute environments.
     */
    @JvmName("rkfqnbeujjescuxv")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied to a SPOT compute environment. This parameter is required for SPOT compute environments. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
     */
    @JvmName("lbinwpehelkhxncy")
    public suspend fun spotIamFleetRole(`value`: Output<String>) {
        this.spotIamFleetRole = value
    }

    /**
     * @param value A list of VPC subnets into which the compute resources are launched.
     */
    @JvmName("serlivlqvgcylira")
    public suspend fun subnets(`value`: Output<List<String>>) {
        this.subnets = value
    }

    @JvmName("xtbypskqugrkcbpf")
    public suspend fun subnets(vararg values: Output<String>) {
        this.subnets = Output.all(values.asList())
    }

    /**
     * @param values A list of VPC subnets into which the compute resources are launched.
     */
    @JvmName("fpjakxtqdytfrkno")
    public suspend fun subnets(values: List<Output<String>>) {
        this.subnets = Output.all(values)
    }

    /**
     * @param value Key-value pair tags to be applied to resources that are launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
     */
    @JvmName("cybbdyhwvxopqkgw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The type of compute environment. Valid items are `EC2`, `SPOT`, `FARGATE` or `FARGATE_SPOT`.
     */
    @JvmName("vytuasbpnhjdrhll")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The allocation strategy to use for the compute resource in case not enough instances of the best fitting instance type can be allocated. Valid items are `BEST_FIT_PROGRESSIVE`, `SPOT_CAPACITY_OPTIMIZED` or `BEST_FIT`. Defaults to `BEST_FIT`. See [AWS docs](https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html) for details. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
     */
    @JvmName("nmfwjiuxeklmllxh")
    public suspend fun allocationStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocationStrategy = mapped
    }

    /**
     * @param value Integer of maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched. For example, if your bid percentage is 20% (`20`), then the Spot price must be below 20% of the current On-Demand price for that EC2 instance. If you leave this field empty, the default value is 100% of the On-Demand price. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
     */
    @JvmName("gaobhjngschbmakw")
    public suspend fun bidPercentage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bidPercentage = mapped
    }

    /**
     * @param value The desired number of EC2 vCPUS in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
     */
    @JvmName("nuuobicfkmyfhssw")
    public suspend fun desiredVcpus(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desiredVcpus = mapped
    }

    /**
     * @param value Provides information used to select Amazon Machine Images (AMIs) for EC2 instances in the compute environment. If Ec2Configuration isn't specified, the default is ECS_AL2. This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     */
    @JvmName("rwctcqxgehcdqnkw")
    public suspend
    fun ec2Configurations(`value`: List<ComputeEnvironmentComputeResourcesEc2ConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ec2Configurations = mapped
    }

    /**
     * @param argument Provides information used to select Amazon Machine Images (AMIs) for EC2 instances in the compute environment. If Ec2Configuration isn't specified, the default is ECS_AL2. This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     */
    @JvmName("yrmymapdcibirbdi")
    public suspend
    fun ec2Configurations(argument: List<suspend ComputeEnvironmentComputeResourcesEc2ConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ComputeEnvironmentComputeResourcesEc2ConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ec2Configurations = mapped
    }

    /**
     * @param argument Provides information used to select Amazon Machine Images (AMIs) for EC2 instances in the compute environment. If Ec2Configuration isn't specified, the default is ECS_AL2. This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     */
    @JvmName("bgdegcckuqoitxma")
    public suspend fun ec2Configurations(
        vararg
        argument: suspend ComputeEnvironmentComputeResourcesEc2ConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ComputeEnvironmentComputeResourcesEc2ConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ec2Configurations = mapped
    }

    /**
     * @param argument Provides information used to select Amazon Machine Images (AMIs) for EC2 instances in the compute environment. If Ec2Configuration isn't specified, the default is ECS_AL2. This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     */
    @JvmName("wdisggopxogtabti")
    public suspend
    fun ec2Configurations(argument: suspend ComputeEnvironmentComputeResourcesEc2ConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ComputeEnvironmentComputeResourcesEc2ConfigurationArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.ec2Configurations = mapped
    }

    /**
     * @param values Provides information used to select Amazon Machine Images (AMIs) for EC2 instances in the compute environment. If Ec2Configuration isn't specified, the default is ECS_AL2. This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
     */
    @JvmName("qrxjodsvbxnvmrns")
    public suspend fun ec2Configurations(
        vararg
        values: ComputeEnvironmentComputeResourcesEc2ConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ec2Configurations = mapped
    }

    /**
     * @param value The EC2 key pair that is used for instances launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
     */
    @JvmName("twdlrenosijrayma")
    public suspend fun ec2KeyPair(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ec2KeyPair = mapped
    }

    /**
     * @param value The Amazon Machine Image (AMI) ID used for instances launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified. (Deprecated, use `ec2_configuration` `image_id_override` instead)
     */
    @JvmName("trcuwrgihubnuwgv")
    public suspend fun imageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageId = mapped
    }

    /**
     * @param value The Amazon ECS instance role applied to Amazon EC2 instances in a compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
     */
    @JvmName("pfbqqvpvwslselaq")
    public suspend fun instanceRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceRole = mapped
    }

    /**
     * @param value A list of instance types that may be launched. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
     */
    @JvmName("dmfvvfjpmhijxhkd")
    public suspend fun instanceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceTypes = mapped
    }

    /**
     * @param values A list of instance types that may be launched. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
     */
    @JvmName("ypbdoadmlgherecu")
    public suspend fun instanceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceTypes = mapped
    }

    /**
     * @param value The launch template to use for your compute resources. See details below. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
     */
    @JvmName("veppabqjqsflssqa")
    public suspend
    fun launchTemplate(`value`: ComputeEnvironmentComputeResourcesLaunchTemplateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplate = mapped
    }

    /**
     * @param argument The launch template to use for your compute resources. See details below. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
     */
    @JvmName("aawhqmhagijgwfja")
    public suspend
    fun launchTemplate(argument: suspend ComputeEnvironmentComputeResourcesLaunchTemplateArgsBuilder.() -> Unit) {
        val toBeMapped = ComputeEnvironmentComputeResourcesLaunchTemplateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.launchTemplate = mapped
    }

    /**
     * @param value The maximum number of EC2 vCPUs that an environment can reach.
     */
    @JvmName("mpwcfgdtoeekvicl")
    public suspend fun maxVcpus(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxVcpus = mapped
    }

    /**
     * @param value The minimum number of EC2 vCPUs that an environment should maintain. For `EC2` or `SPOT` compute environments, if the parameter is not explicitly defined, a `0` default value will be set. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
     */
    @JvmName("wsumpmblfxnuhwgf")
    public suspend fun minVcpus(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minVcpus = mapped
    }

    /**
     * @param value The Amazon EC2 placement group to associate with your compute resources.
     */
    @JvmName("ivdgyslsjauxcdxq")
    public suspend fun placementGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placementGroup = mapped
    }

    /**
     * @param value A list of EC2 security group that are associated with instances launched in the compute environment. This parameter is required for Fargate compute environments.
     */
    @JvmName("hvgwjssarjpfqcte")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values A list of EC2 security group that are associated with instances launched in the compute environment. This parameter is required for Fargate compute environments.
     */
    @JvmName("fbardkxrjqihujdo")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied to a SPOT compute environment. This parameter is required for SPOT compute environments. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
     */
    @JvmName("kphsluhfljvdoqyx")
    public suspend fun spotIamFleetRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotIamFleetRole = mapped
    }

    /**
     * @param value A list of VPC subnets into which the compute resources are launched.
     */
    @JvmName("ompdnfncvktsfepc")
    public suspend fun subnets(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param values A list of VPC subnets into which the compute resources are launched.
     */
    @JvmName("qflfevppsolkfdmd")
    public suspend fun subnets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param value Key-value pair tags to be applied to resources that are launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
     */
    @JvmName("gffmrqtpybgnvnqu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value pair tags to be applied to resources that are launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
     */
    @JvmName("crppewlqhwsrymxb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The type of compute environment. Valid items are `EC2`, `SPOT`, `FARGATE` or `FARGATE_SPOT`.
     */
    @JvmName("rvfkvoscrpskmwrw")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ComputeEnvironmentComputeResourcesArgs =
        ComputeEnvironmentComputeResourcesArgs(
            allocationStrategy = allocationStrategy,
            bidPercentage = bidPercentage,
            desiredVcpus = desiredVcpus,
            ec2Configurations = ec2Configurations,
            ec2KeyPair = ec2KeyPair,
            imageId = imageId,
            instanceRole = instanceRole,
            instanceTypes = instanceTypes,
            launchTemplate = launchTemplate,
            maxVcpus = maxVcpus ?: throw PulumiNullFieldException("maxVcpus"),
            minVcpus = minVcpus,
            placementGroup = placementGroup,
            securityGroupIds = securityGroupIds,
            spotIamFleetRole = spotIamFleetRole,
            subnets = subnets ?: throw PulumiNullFieldException("subnets"),
            tags = tags,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
