@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.inputs

import com.pulumi.aws.batch.inputs.ComputeEnvironmentEksConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property eksClusterArn The Amazon Resource Name (ARN) of the Amazon EKS cluster.
 * @property kubernetesNamespace The namespace of the Amazon EKS cluster. AWS Batch manages pods in this namespace.
 */
public data class ComputeEnvironmentEksConfigurationArgs(
    public val eksClusterArn: Output<String>,
    public val kubernetesNamespace: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.batch.inputs.ComputeEnvironmentEksConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.batch.inputs.ComputeEnvironmentEksConfigurationArgs =
        com.pulumi.aws.batch.inputs.ComputeEnvironmentEksConfigurationArgs.builder()
            .eksClusterArn(eksClusterArn.applyValue({ args0 -> args0 }))
            .kubernetesNamespace(kubernetesNamespace.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ComputeEnvironmentEksConfigurationArgs].
 */
@PulumiTagMarker
public class ComputeEnvironmentEksConfigurationArgsBuilder internal constructor() {
    private var eksClusterArn: Output<String>? = null

    private var kubernetesNamespace: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the Amazon EKS cluster.
     */
    @JvmName("bshsfjsyfvyfocnq")
    public suspend fun eksClusterArn(`value`: Output<String>) {
        this.eksClusterArn = value
    }

    /**
     * @param value The namespace of the Amazon EKS cluster. AWS Batch manages pods in this namespace.
     */
    @JvmName("jlcpkbujrvkcpops")
    public suspend fun kubernetesNamespace(`value`: Output<String>) {
        this.kubernetesNamespace = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Amazon EKS cluster.
     */
    @JvmName("atwrnsxfjcsfqiym")
    public suspend fun eksClusterArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eksClusterArn = mapped
    }

    /**
     * @param value The namespace of the Amazon EKS cluster. AWS Batch manages pods in this namespace.
     */
    @JvmName("nikorprfbavkrmbq")
    public suspend fun kubernetesNamespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kubernetesNamespace = mapped
    }

    internal fun build(): ComputeEnvironmentEksConfigurationArgs =
        ComputeEnvironmentEksConfigurationArgs(
            eksClusterArn = eksClusterArn ?: throw PulumiNullFieldException("eksClusterArn"),
            kubernetesNamespace = kubernetesNamespace ?: throw PulumiNullFieldException("kubernetesNamespace"),
        )
}
