@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.inputs

import com.pulumi.aws.batch.inputs.GetJobQueuePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getJobQueue.
 * @property name Name of the job queue.
 * @property tags Key-value map of resource tags
 */
public data class GetJobQueuePlainArgs(
    public val name: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.batch.inputs.GetJobQueuePlainArgs> {
    override fun toJava(): com.pulumi.aws.batch.inputs.GetJobQueuePlainArgs =
        com.pulumi.aws.batch.inputs.GetJobQueuePlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetJobQueuePlainArgs].
 */
@PulumiTagMarker
public class GetJobQueuePlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Name of the job queue.
     */
    @JvmName("iayuwhveyruuwypv")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Key-value map of resource tags
     */
    @JvmName("rvmjwirwcyuatlri")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags
     */
    @JvmName("nrruyjofjuirmvfy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetJobQueuePlainArgs = GetJobQueuePlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        tags = tags,
    )
}
