@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.inputs

import com.pulumi.aws.batch.inputs.JobDefinitionRetryStrategyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property attempts The number of times to move a job to the `RUNNABLE` status. You may specify between `1` and `10` attempts.
 * @property evaluateOnExits The evaluate on exit conditions under which the job should be retried or failed. If this parameter is specified, then the `attempts` parameter must also be specified. You may specify up to 5 configuration blocks.
 */
public data class JobDefinitionRetryStrategyArgs(
    public val attempts: Output<Int>? = null,
    public val evaluateOnExits: Output<List<JobDefinitionRetryStrategyEvaluateOnExitArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.batch.inputs.JobDefinitionRetryStrategyArgs> {
    override fun toJava(): com.pulumi.aws.batch.inputs.JobDefinitionRetryStrategyArgs =
        com.pulumi.aws.batch.inputs.JobDefinitionRetryStrategyArgs.builder()
            .attempts(attempts?.applyValue({ args0 -> args0 }))
            .evaluateOnExits(
                evaluateOnExits?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [JobDefinitionRetryStrategyArgs].
 */
@PulumiTagMarker
public class JobDefinitionRetryStrategyArgsBuilder internal constructor() {
    private var attempts: Output<Int>? = null

    private var evaluateOnExits: Output<List<JobDefinitionRetryStrategyEvaluateOnExitArgs>>? = null

    /**
     * @param value The number of times to move a job to the `RUNNABLE` status. You may specify between `1` and `10` attempts.
     */
    @JvmName("hqnovokdyttpvmdi")
    public suspend fun attempts(`value`: Output<Int>) {
        this.attempts = value
    }

    /**
     * @param value The evaluate on exit conditions under which the job should be retried or failed. If this parameter is specified, then the `attempts` parameter must also be specified. You may specify up to 5 configuration blocks.
     */
    @JvmName("qeohwtsqoemnpnni")
    public suspend
    fun evaluateOnExits(`value`: Output<List<JobDefinitionRetryStrategyEvaluateOnExitArgs>>) {
        this.evaluateOnExits = value
    }

    @JvmName("idgjjlikndsktmob")
    public suspend fun evaluateOnExits(
        vararg
        values: Output<JobDefinitionRetryStrategyEvaluateOnExitArgs>,
    ) {
        this.evaluateOnExits = Output.all(values.asList())
    }

    /**
     * @param values The evaluate on exit conditions under which the job should be retried or failed. If this parameter is specified, then the `attempts` parameter must also be specified. You may specify up to 5 configuration blocks.
     */
    @JvmName("ptfluyfcogaeedam")
    public suspend
    fun evaluateOnExits(values: List<Output<JobDefinitionRetryStrategyEvaluateOnExitArgs>>) {
        this.evaluateOnExits = Output.all(values)
    }

    /**
     * @param value The number of times to move a job to the `RUNNABLE` status. You may specify between `1` and `10` attempts.
     */
    @JvmName("fmpsbsqbiioojplm")
    public suspend fun attempts(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attempts = mapped
    }

    /**
     * @param value The evaluate on exit conditions under which the job should be retried or failed. If this parameter is specified, then the `attempts` parameter must also be specified. You may specify up to 5 configuration blocks.
     */
    @JvmName("vlykooexuqinaiva")
    public suspend fun evaluateOnExits(`value`: List<JobDefinitionRetryStrategyEvaluateOnExitArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.evaluateOnExits = mapped
    }

    /**
     * @param argument The evaluate on exit conditions under which the job should be retried or failed. If this parameter is specified, then the `attempts` parameter must also be specified. You may specify up to 5 configuration blocks.
     */
    @JvmName("qviwinqqkigkibxs")
    public suspend
    fun evaluateOnExits(argument: List<suspend JobDefinitionRetryStrategyEvaluateOnExitArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            JobDefinitionRetryStrategyEvaluateOnExitArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.evaluateOnExits = mapped
    }

    /**
     * @param argument The evaluate on exit conditions under which the job should be retried or failed. If this parameter is specified, then the `attempts` parameter must also be specified. You may specify up to 5 configuration blocks.
     */
    @JvmName("mtxjrxkqonqpbtwj")
    public suspend fun evaluateOnExits(
        vararg
        argument: suspend JobDefinitionRetryStrategyEvaluateOnExitArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            JobDefinitionRetryStrategyEvaluateOnExitArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.evaluateOnExits = mapped
    }

    /**
     * @param argument The evaluate on exit conditions under which the job should be retried or failed. If this parameter is specified, then the `attempts` parameter must also be specified. You may specify up to 5 configuration blocks.
     */
    @JvmName("pptfadbyxisoyaya")
    public suspend
    fun evaluateOnExits(argument: suspend JobDefinitionRetryStrategyEvaluateOnExitArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            JobDefinitionRetryStrategyEvaluateOnExitArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.evaluateOnExits = mapped
    }

    /**
     * @param values The evaluate on exit conditions under which the job should be retried or failed. If this parameter is specified, then the `attempts` parameter must also be specified. You may specify up to 5 configuration blocks.
     */
    @JvmName("astugdfuvumckwdw")
    public suspend fun evaluateOnExits(vararg values: JobDefinitionRetryStrategyEvaluateOnExitArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.evaluateOnExits = mapped
    }

    internal fun build(): JobDefinitionRetryStrategyArgs = JobDefinitionRetryStrategyArgs(
        attempts = attempts,
        evaluateOnExits = evaluateOnExits,
    )
}
