@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.inputs

import com.pulumi.aws.batch.inputs.JobDefinitionRetryStrategyEvaluateOnExitArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property action Specifies the action to take if all of the specified conditions are met. The values are not case sensitive. Valid values: `RETRY`, `EXIT`.
 * @property onExitCode A glob pattern to match against the decimal representation of the exit code returned for a job.
 * @property onReason A glob pattern to match against the reason returned for a job.
 * @property onStatusReason A glob pattern to match against the status reason returned for a job.
 */
public data class JobDefinitionRetryStrategyEvaluateOnExitArgs(
    public val action: Output<String>,
    public val onExitCode: Output<String>? = null,
    public val onReason: Output<String>? = null,
    public val onStatusReason: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.batch.inputs.JobDefinitionRetryStrategyEvaluateOnExitArgs> {
    override fun toJava(): com.pulumi.aws.batch.inputs.JobDefinitionRetryStrategyEvaluateOnExitArgs =
        com.pulumi.aws.batch.inputs.JobDefinitionRetryStrategyEvaluateOnExitArgs.builder()
            .action(action.applyValue({ args0 -> args0 }))
            .onExitCode(onExitCode?.applyValue({ args0 -> args0 }))
            .onReason(onReason?.applyValue({ args0 -> args0 }))
            .onStatusReason(onStatusReason?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobDefinitionRetryStrategyEvaluateOnExitArgs].
 */
@PulumiTagMarker
public class JobDefinitionRetryStrategyEvaluateOnExitArgsBuilder internal constructor() {
    private var action: Output<String>? = null

    private var onExitCode: Output<String>? = null

    private var onReason: Output<String>? = null

    private var onStatusReason: Output<String>? = null

    /**
     * @param value Specifies the action to take if all of the specified conditions are met. The values are not case sensitive. Valid values: `RETRY`, `EXIT`.
     */
    @JvmName("vslnpithibowlqvl")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value A glob pattern to match against the decimal representation of the exit code returned for a job.
     */
    @JvmName("bqqkjypbbbvellso")
    public suspend fun onExitCode(`value`: Output<String>) {
        this.onExitCode = value
    }

    /**
     * @param value A glob pattern to match against the reason returned for a job.
     */
    @JvmName("cwtonjghkieekrsn")
    public suspend fun onReason(`value`: Output<String>) {
        this.onReason = value
    }

    /**
     * @param value A glob pattern to match against the status reason returned for a job.
     */
    @JvmName("yjmndvyqvsmouxxq")
    public suspend fun onStatusReason(`value`: Output<String>) {
        this.onStatusReason = value
    }

    /**
     * @param value Specifies the action to take if all of the specified conditions are met. The values are not case sensitive. Valid values: `RETRY`, `EXIT`.
     */
    @JvmName("qcnotwklcstxsaec")
    public suspend fun action(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value A glob pattern to match against the decimal representation of the exit code returned for a job.
     */
    @JvmName("efviqthprfwtsslv")
    public suspend fun onExitCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onExitCode = mapped
    }

    /**
     * @param value A glob pattern to match against the reason returned for a job.
     */
    @JvmName("ubbtxqaokbsiqcpw")
    public suspend fun onReason(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onReason = mapped
    }

    /**
     * @param value A glob pattern to match against the status reason returned for a job.
     */
    @JvmName("mxigntqiynejiace")
    public suspend fun onStatusReason(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onStatusReason = mapped
    }

    internal fun build(): JobDefinitionRetryStrategyEvaluateOnExitArgs =
        JobDefinitionRetryStrategyEvaluateOnExitArgs(
            action = action ?: throw PulumiNullFieldException("action"),
            onExitCode = onExitCode,
            onReason = onReason,
            onStatusReason = onStatusReason,
        )
}
