@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.inputs

import com.pulumi.aws.batch.inputs.SchedulingPolicyFairSharePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property computeReservation A value used to reserve some of the available maximum vCPU for fair share identifiers that have not yet been used. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html).
 * @property shareDecaySeconds
 * @property shareDistributions One or more share distribution blocks which define the weights for the fair share identifiers for the fair share policy. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html). The `share_distribution` block is documented below.
 */
public data class SchedulingPolicyFairSharePolicyArgs(
    public val computeReservation: Output<Int>? = null,
    public val shareDecaySeconds: Output<Int>? = null,
    public val shareDistributions: Output<List<SchedulingPolicyFairSharePolicyShareDistributionArgs>>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.batch.inputs.SchedulingPolicyFairSharePolicyArgs> {
    override fun toJava(): com.pulumi.aws.batch.inputs.SchedulingPolicyFairSharePolicyArgs =
        com.pulumi.aws.batch.inputs.SchedulingPolicyFairSharePolicyArgs.builder()
            .computeReservation(computeReservation?.applyValue({ args0 -> args0 }))
            .shareDecaySeconds(shareDecaySeconds?.applyValue({ args0 -> args0 }))
            .shareDistributions(
                shareDistributions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [SchedulingPolicyFairSharePolicyArgs].
 */
@PulumiTagMarker
public class SchedulingPolicyFairSharePolicyArgsBuilder internal constructor() {
    private var computeReservation: Output<Int>? = null

    private var shareDecaySeconds: Output<Int>? = null

    private var shareDistributions:
        Output<List<SchedulingPolicyFairSharePolicyShareDistributionArgs>>? = null

    /**
     * @param value A value used to reserve some of the available maximum vCPU for fair share identifiers that have not yet been used. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html).
     */
    @JvmName("ikfyokiqqxcpxegv")
    public suspend fun computeReservation(`value`: Output<Int>) {
        this.computeReservation = value
    }

    /**
     * @param value
     */
    @JvmName("gdyftbnonikmmxqj")
    public suspend fun shareDecaySeconds(`value`: Output<Int>) {
        this.shareDecaySeconds = value
    }

    /**
     * @param value One or more share distribution blocks which define the weights for the fair share identifiers for the fair share policy. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html). The `share_distribution` block is documented below.
     */
    @JvmName("ujdglqklkmaagxwd")
    public suspend
    fun shareDistributions(`value`: Output<List<SchedulingPolicyFairSharePolicyShareDistributionArgs>>) {
        this.shareDistributions = value
    }

    @JvmName("cfofxxcgowpewbok")
    public suspend fun shareDistributions(
        vararg
        values: Output<SchedulingPolicyFairSharePolicyShareDistributionArgs>,
    ) {
        this.shareDistributions = Output.all(values.asList())
    }

    /**
     * @param values One or more share distribution blocks which define the weights for the fair share identifiers for the fair share policy. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html). The `share_distribution` block is documented below.
     */
    @JvmName("drjsgocglumqsyxw")
    public suspend
    fun shareDistributions(values: List<Output<SchedulingPolicyFairSharePolicyShareDistributionArgs>>) {
        this.shareDistributions = Output.all(values)
    }

    /**
     * @param value A value used to reserve some of the available maximum vCPU for fair share identifiers that have not yet been used. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html).
     */
    @JvmName("vktsytuddhkdgnfl")
    public suspend fun computeReservation(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeReservation = mapped
    }

    /**
     * @param value
     */
    @JvmName("dyykgqgfshooeorc")
    public suspend fun shareDecaySeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareDecaySeconds = mapped
    }

    /**
     * @param value One or more share distribution blocks which define the weights for the fair share identifiers for the fair share policy. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html). The `share_distribution` block is documented below.
     */
    @JvmName("pjfjinhqygajelxa")
    public suspend
    fun shareDistributions(`value`: List<SchedulingPolicyFairSharePolicyShareDistributionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareDistributions = mapped
    }

    /**
     * @param argument One or more share distribution blocks which define the weights for the fair share identifiers for the fair share policy. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html). The `share_distribution` block is documented below.
     */
    @JvmName("trtkmoqjuflnmnrf")
    public suspend
    fun shareDistributions(argument: List<suspend SchedulingPolicyFairSharePolicyShareDistributionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SchedulingPolicyFairSharePolicyShareDistributionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.shareDistributions = mapped
    }

    /**
     * @param argument One or more share distribution blocks which define the weights for the fair share identifiers for the fair share policy. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html). The `share_distribution` block is documented below.
     */
    @JvmName("inasigdnorayhdgm")
    public suspend fun shareDistributions(
        vararg
        argument: suspend SchedulingPolicyFairSharePolicyShareDistributionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SchedulingPolicyFairSharePolicyShareDistributionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.shareDistributions = mapped
    }

    /**
     * @param argument One or more share distribution blocks which define the weights for the fair share identifiers for the fair share policy. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html). The `share_distribution` block is documented below.
     */
    @JvmName("klqwitsmxnoimgok")
    public suspend
    fun shareDistributions(argument: suspend SchedulingPolicyFairSharePolicyShareDistributionArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                SchedulingPolicyFairSharePolicyShareDistributionArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.shareDistributions = mapped
    }

    /**
     * @param values One or more share distribution blocks which define the weights for the fair share identifiers for the fair share policy. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html). The `share_distribution` block is documented below.
     */
    @JvmName("unuxvpixtldtyafy")
    public suspend fun shareDistributions(
        vararg
        values: SchedulingPolicyFairSharePolicyShareDistributionArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.shareDistributions = mapped
    }

    internal fun build(): SchedulingPolicyFairSharePolicyArgs = SchedulingPolicyFairSharePolicyArgs(
        computeReservation = computeReservation,
        shareDecaySeconds = shareDecaySeconds,
        shareDistributions = shareDistributions,
    )
}
