@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.inputs

import com.pulumi.aws.batch.inputs.SchedulingPolicyFairSharePolicyShareDistributionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property shareIdentifier A fair share identifier or fair share identifier prefix. For more information, see [ShareAttributes](https://docs.aws.amazon.com/batch/latest/APIReference/API_ShareAttributes.html).
 * @property weightFactor The weight factor for the fair share identifier. For more information, see [ShareAttributes](https://docs.aws.amazon.com/batch/latest/APIReference/API_ShareAttributes.html).
 */
public data class SchedulingPolicyFairSharePolicyShareDistributionArgs(
    public val shareIdentifier: Output<String>,
    public val weightFactor: Output<Double>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.batch.inputs.SchedulingPolicyFairSharePolicyShareDistributionArgs> {
    override fun toJava():
        com.pulumi.aws.batch.inputs.SchedulingPolicyFairSharePolicyShareDistributionArgs =
        com.pulumi.aws.batch.inputs.SchedulingPolicyFairSharePolicyShareDistributionArgs.builder()
            .shareIdentifier(shareIdentifier.applyValue({ args0 -> args0 }))
            .weightFactor(weightFactor?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SchedulingPolicyFairSharePolicyShareDistributionArgs].
 */
@PulumiTagMarker
public class SchedulingPolicyFairSharePolicyShareDistributionArgsBuilder internal constructor() {
    private var shareIdentifier: Output<String>? = null

    private var weightFactor: Output<Double>? = null

    /**
     * @param value A fair share identifier or fair share identifier prefix. For more information, see [ShareAttributes](https://docs.aws.amazon.com/batch/latest/APIReference/API_ShareAttributes.html).
     */
    @JvmName("bkyigchnqoqonoeq")
    public suspend fun shareIdentifier(`value`: Output<String>) {
        this.shareIdentifier = value
    }

    /**
     * @param value The weight factor for the fair share identifier. For more information, see [ShareAttributes](https://docs.aws.amazon.com/batch/latest/APIReference/API_ShareAttributes.html).
     */
    @JvmName("edvudwthekqtuooq")
    public suspend fun weightFactor(`value`: Output<Double>) {
        this.weightFactor = value
    }

    /**
     * @param value A fair share identifier or fair share identifier prefix. For more information, see [ShareAttributes](https://docs.aws.amazon.com/batch/latest/APIReference/API_ShareAttributes.html).
     */
    @JvmName("viqofidyffihwgbc")
    public suspend fun shareIdentifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.shareIdentifier = mapped
    }

    /**
     * @param value The weight factor for the fair share identifier. For more information, see [ShareAttributes](https://docs.aws.amazon.com/batch/latest/APIReference/API_ShareAttributes.html).
     */
    @JvmName("lxvrixrbirqqwfei")
    public suspend fun weightFactor(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weightFactor = mapped
    }

    internal fun build(): SchedulingPolicyFairSharePolicyShareDistributionArgs =
        SchedulingPolicyFairSharePolicyShareDistributionArgs(
            shareIdentifier = shareIdentifier ?: throw PulumiNullFieldException("shareIdentifier"),
            weightFactor = weightFactor,
        )
}
