@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property imageIdOverride The AMI ID used for instances launched in the compute environment that match the image type. This setting overrides the `image_id` argument in the `compute_resources` block.
 * @property imageType The image type to match with the instance type to select an AMI. If the `image_id_override` parameter isn't specified, then a recent [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami) (`ECS_AL2`) is used.
 */
public data class ComputeEnvironmentComputeResourcesEc2Configuration(
    public val imageIdOverride: String? = null,
    public val imageType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.batch.outputs.ComputeEnvironmentComputeResourcesEc2Configuration):
            ComputeEnvironmentComputeResourcesEc2Configuration =
            ComputeEnvironmentComputeResourcesEc2Configuration(
                imageIdOverride = javaType.imageIdOverride().map({ args0 -> args0 }).orElse(null),
                imageType = javaType.imageType().map({ args0 -> args0 }).orElse(null),
            )
    }
}
