@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getComputeEnvironment.
 * @property arn ARN of the compute environment.
 * @property computeEnvironmentName
 * @property ecsClusterArn ARN of the underlying Amazon ECS cluster used by the compute environment.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property serviceRole ARN of the IAM role that allows AWS Batch to make calls to other AWS services on your behalf.
 * @property state State of the compute environment (for example, `ENABLED` or `DISABLED`). If the state is `ENABLED`, then the compute environment accepts jobs from a queue and can scale out automatically based on queues.
 * @property status Current status of the compute environment (for example, `CREATING` or `VALID`).
 * @property statusReason Short, human-readable string to provide additional details about the current status of the compute environment.
 * @property tags Key-value map of resource tags
 * @property type Type of the compute environment (for example, `MANAGED` or `UNMANAGED`).
 */
public data class GetComputeEnvironmentResult(
    public val arn: String,
    public val computeEnvironmentName: String,
    public val ecsClusterArn: String,
    public val id: String,
    public val serviceRole: String,
    public val state: String,
    public val status: String,
    public val statusReason: String,
    public val tags: Map<String, String>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.GetComputeEnvironmentResult):
            GetComputeEnvironmentResult = GetComputeEnvironmentResult(
            arn = javaType.arn(),
            computeEnvironmentName = javaType.computeEnvironmentName(),
            ecsClusterArn = javaType.ecsClusterArn(),
            id = javaType.id(),
            serviceRole = javaType.serviceRole(),
            state = javaType.state(),
            status = javaType.status(),
            statusReason = javaType.statusReason(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
