@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getJobQueue.
 * @property arn ARN of the job queue.
 * @property computeEnvironmentOrders The compute environments that are attached to the job queue and the order in
 * which job placement is preferred. Compute environments are selected for job placement in ascending order.
 * * `compute_environment_order.#.order` - The order of the compute environment.
 * * `compute_environment_order.#.compute_environment` - The ARN of the compute environment.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property priority Priority of the job queue. Job queues with a higher priority are evaluated first when
 * associated with the same compute environment.
 * @property schedulingPolicyArn The ARN of the fair share scheduling policy. If this attribute has a value, the job queue uses a fair share scheduling policy. If this attribute does not have a value, the job queue uses a first in, first out (FIFO) scheduling policy.
 * @property state Describes the ability of the queue to accept new jobs (for example, `ENABLED` or `DISABLED`).
 * @property status Current status of the job queue (for example, `CREATING` or `VALID`).
 * @property statusReason Short, human-readable string to provide additional details about the current status
 * of the job queue.
 * @property tags Key-value map of resource tags
 */
public data class GetJobQueueResult(
    public val arn: String,
    public val computeEnvironmentOrders: List<GetJobQueueComputeEnvironmentOrder>,
    public val id: String,
    public val name: String,
    public val priority: Int,
    public val schedulingPolicyArn: String,
    public val state: String,
    public val status: String,
    public val statusReason: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.GetJobQueueResult): GetJobQueueResult =
            GetJobQueueResult(
                arn = javaType.arn(),
                computeEnvironmentOrders = javaType.computeEnvironmentOrders().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.batch.kotlin.outputs.GetJobQueueComputeEnvironmentOrder.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                name = javaType.name(),
                priority = javaType.priority(),
                schedulingPolicyArn = javaType.schedulingPolicyArn(),
                state = javaType.state(),
                status = javaType.status(),
                statusReason = javaType.statusReason(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
