@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getSchedulingPolicy.
 * @property arn
 * @property fairSharePolicies
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name Name of the scheduling policy.
 * @property tags Key-value map of resource tags
 */
public data class GetSchedulingPolicyResult(
    public val arn: String,
    public val fairSharePolicies: List<GetSchedulingPolicyFairSharePolicy>,
    public val id: String,
    public val name: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.GetSchedulingPolicyResult):
            GetSchedulingPolicyResult = GetSchedulingPolicyResult(
            arn = javaType.arn(),
            fairSharePolicies = javaType.fairSharePolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.batch.kotlin.outputs.GetSchedulingPolicyFairSharePolicy.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            name = javaType.name(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
