@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property attempts The number of times to move a job to the `RUNNABLE` status. You may specify between `1` and `10` attempts.
 * @property evaluateOnExits The evaluate on exit conditions under which the job should be retried or failed. If this parameter is specified, then the `attempts` parameter must also be specified. You may specify up to 5 configuration blocks.
 */
public data class JobDefinitionRetryStrategy(
    public val attempts: Int? = null,
    public val evaluateOnExits: List<JobDefinitionRetryStrategyEvaluateOnExit>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.JobDefinitionRetryStrategy):
            JobDefinitionRetryStrategy = JobDefinitionRetryStrategy(
            attempts = javaType.attempts().map({ args0 -> args0 }).orElse(null),
            evaluateOnExits = javaType.evaluateOnExits().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.batch.kotlin.outputs.JobDefinitionRetryStrategyEvaluateOnExit.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
