@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property action Specifies the action to take if all of the specified conditions are met. The values are not case sensitive. Valid values: `RETRY`, `EXIT`.
 * @property onExitCode A glob pattern to match against the decimal representation of the exit code returned for a job.
 * @property onReason A glob pattern to match against the reason returned for a job.
 * @property onStatusReason A glob pattern to match against the status reason returned for a job.
 */
public data class JobDefinitionRetryStrategyEvaluateOnExit(
    public val action: String,
    public val onExitCode: String? = null,
    public val onReason: String? = null,
    public val onStatusReason: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.batch.outputs.JobDefinitionRetryStrategyEvaluateOnExit):
            JobDefinitionRetryStrategyEvaluateOnExit = JobDefinitionRetryStrategyEvaluateOnExit(
            action = javaType.action(),
            onExitCode = javaType.onExitCode().map({ args0 -> args0 }).orElse(null),
            onReason = javaType.onReason().map({ args0 -> args0 }).orElse(null),
            onStatusReason = javaType.onStatusReason().map({ args0 -> args0 }).orElse(null),
        )
    }
}
