@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property attemptDurationSeconds The time duration in seconds after which AWS Batch terminates your jobs if they have not finished. The minimum value for the timeout is `60` seconds.
 */
public data class JobDefinitionTimeout(
    public val attemptDurationSeconds: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.JobDefinitionTimeout):
            JobDefinitionTimeout = JobDefinitionTimeout(
            attemptDurationSeconds = javaType.attemptDurationSeconds().map({ args0 -> args0 }).orElse(null),
        )
    }
}
