@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.batch.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property computeReservation A value used to reserve some of the available maximum vCPU for fair share identifiers that have not yet been used. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html).
 * @property shareDecaySeconds
 * @property shareDistributions One or more share distribution blocks which define the weights for the fair share identifiers for the fair share policy. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html). The `share_distribution` block is documented below.
 */
public data class SchedulingPolicyFairSharePolicy(
    public val computeReservation: Int? = null,
    public val shareDecaySeconds: Int? = null,
    public val shareDistributions: List<SchedulingPolicyFairSharePolicyShareDistribution>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.batch.outputs.SchedulingPolicyFairSharePolicy):
            SchedulingPolicyFairSharePolicy = SchedulingPolicyFairSharePolicy(
            computeReservation = javaType.computeReservation().map({ args0 -> args0 }).orElse(null),
            shareDecaySeconds = javaType.shareDecaySeconds().map({ args0 -> args0 }).orElse(null),
            shareDistributions = javaType.shareDistributions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.batch.kotlin.outputs.SchedulingPolicyFairSharePolicyShareDistribution.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
